/*
 * Decompiled with CFR 0.152.
 */
package net.hayato08.udonmod.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.WaterDropParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GraySplashParticle
extends WaterDropParticle {
    protected GraySplashParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
        super(level, x, y, z);
        this.gravity = 0.04f;
        this.xd = xd * 0.3 + (Math.random() * 2.0 - 1.0) * 0.02;
        this.yd = yd * 0.3 + (Math.random() * 2.0 - 1.0) * 0.02;
        this.zd = zd * 0.3 + (Math.random() * 2.0 - 1.0) * 0.02;
        this.lifetime = (int)(8.0 / (Math.random() * 0.8 + 0.2)) + 4;
        this.setColor(1.0f, 1.0f, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Provider(SpriteSet sprite) {
            this.sprite = sprite;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            GraySplashParticle particle = new GraySplashParticle(level, x, y, z, xd, yd, zd);
            particle.pickSprite(this.sprite);
            return particle;
        }
    }
}

