/*
 * Decompiled with CFR 0.152.
 */
package net.hayato08.udonmod.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.hayato08.udonmod.recipe.UdonRecipes;
import net.hayato08.udonmod.recipe.UniversalCookingBlockRecipeInput;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record UniversalCookingBlockRecipe(Ingredient inputItem, ItemStack output) implements Recipe<UniversalCookingBlockRecipeInput>
{
    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.inputItem);
        return list;
    }

    public boolean matches(UniversalCookingBlockRecipeInput universalCookingBlockRecipeInput, Level level) {
        if (level.isClientSide()) {
            return false;
        }
        return this.inputItem.test(universalCookingBlockRecipeInput.getItem(0));
    }

    public ItemStack assemble(UniversalCookingBlockRecipeInput universalCookingBlockRecipeInput, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)UdonRecipes.UNIVERSAL_BLOCK_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)UdonRecipes.UNIVERSAL_COOKING_BLOCK_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<UniversalCookingBlockRecipe> {
        public static final MapCodec<UniversalCookingBlockRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(UniversalCookingBlockRecipe::inputItem), (App)ItemStack.CODEC.fieldOf("result").forGetter(UniversalCookingBlockRecipe::output)).apply((Applicative)inst, UniversalCookingBlockRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, UniversalCookingBlockRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, UniversalCookingBlockRecipe::inputItem, (StreamCodec)ItemStack.STREAM_CODEC, UniversalCookingBlockRecipe::output, UniversalCookingBlockRecipe::new);

        public MapCodec<UniversalCookingBlockRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, UniversalCookingBlockRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

