/*
 * Decompiled with CFR 0.152.
 */
package net.sn0wix_.notEnoughKeybinds.keybinds.presets;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3675;
import net.sn0wix_.notEnoughKeybinds.NotEnoughKeybinds;
import net.sn0wix_.notEnoughKeybinds.config.EquipElytraConfig;
import net.sn0wix_.notEnoughKeybinds.config.NotEKSettings;
import net.sn0wix_.notEnoughKeybinds.keybinds.ChatKeys;
import net.sn0wix_.notEnoughKeybinds.keybinds.F3DebugKeys;
import net.sn0wix_.notEnoughKeybinds.keybinds.InventoryKeys;
import net.sn0wix_.notEnoughKeybinds.keybinds.PresetKeys;
import net.sn0wix_.notEnoughKeybinds.keybinds.custom.INotEKKeybinding;
import net.sn0wix_.notEnoughKeybinds.util.TextUtils;
import net.sn0wix_.notEnoughKeybinds.util.Utils;

public class PresetLoader {
    public static final Float CURRENT_VERSION = Float.valueOf(1.0f);
    public static final File PRESETS_DIR = new File("config" + File.separator + "not-enough-keybinds" + File.separator + "presets");
    private static final ArrayList<KeybindPreset> presets = new ArrayList();
    private static KeybindPreset currentPreset = null;

    public static void init() {
        PRESETS_DIR.mkdirs();
        List<File> presetFiles = List.of(Objects.requireNonNull(PRESETS_DIR.listFiles()));
        presetFiles.forEach(file -> {
            try {
                float version;
                BufferedReader reader = new BufferedReader(new FileReader((File)file));
                try {
                    version = Float.parseFloat(Utils.nextValue("version", reader));
                }
                catch (NumberFormatException e) {
                    NotEnoughKeybinds.LOGGER.error("The version string is not a number!");
                    throw new RuntimeException(e);
                }
                if (version == 0.0f) {
                    NotEnoughKeybinds.LOGGER.error("Incorrect version number in " + file.getAbsolutePath());
                    throw new Exception();
                }
                String name = Utils.nextValue("preset_name", reader);
                String description = Utils.nextValue("description", reader);
                ArrayList<String> content = new ArrayList<String>();
                reader.lines().forEach(content::add);
                reader.close();
                presets.add(new KeybindPreset(file.getName(), version, name, description, content));
            }
            catch (Exception e) {
                NotEnoughKeybinds.LOGGER.info("Could not read from file " + file.getAbsolutePath(), (Throwable)e);
            }
        });
        AtomicBoolean bl = new AtomicBoolean(false);
        for (KeybindPreset preset : presets) {
            if (!preset.getName().equals(PresetLoader.getCurrentPresetName())) continue;
            bl.set(true);
            break;
        }
        if (!bl.get()) {
            NotEnoughKeybinds.GENERAL_CONFIG.currentPreset = "none";
            NotEKSettings.saveConfig();
        }
        NotEnoughKeybinds.LOGGER.info("Presets initialized");
    }

    public static void reload(boolean showToastNotification) {
        NotEnoughKeybinds.LOGGER.info("Reloading presets...");
        if (showToastNotification) {
            Utils.showToastNotification(TextUtils.getText("preset.reload"));
        }
        currentPreset = null;
        presets.clear();
        PresetLoader.init();
    }

    public static void loadPreset(KeybindPreset preset) {
        if (preset == null) {
            NotEnoughKeybinds.LOGGER.warn("Preset can not be null!");
            return;
        }
        preset.content.forEach(line -> {
            String translation = line.split(":")[0];
            String value = Utils.getValue(line);
            if (translation.isEmpty() || value.isEmpty()) {
                NotEnoughKeybinds.LOGGER.error("Incorrect keybinding entry in preset" + preset.name + ": " + translation + ":" + value);
            } else {
                class_315 options = class_310.method_1551().field_1690;
                boolean found = false;
                if (translation.equals(InventoryKeys.EQUIP_ELYTRA.method_1431())) {
                    NotEnoughKeybinds.EQUIP_ELYTRA_CONFIG.autoDetect = value.equals("auto-detect");
                    EquipElytraConfig.saveConfig();
                    if (value.equals("auto-detect")) {
                        found = true;
                        value = "key.keyboard.unknown";
                    }
                }
                for (int i = 0; i < options.field_1839.length; ++i) {
                    class_304 binding = options.field_1839[i];
                    if (!binding.method_1431().equals(translation) || binding.method_1431().equals(PresetKeys.NEXT_PRESET_GLOBAL.method_1431()) || binding.method_1431().equals(PresetKeys.PREVIOUS_PRESET_GLOBAL.method_1431())) continue;
                    binding.method_1422(class_3675.method_15981((String)value));
                    found = true;
                    break;
                }
                if (!found && translation.contains("key.not-enough-keybinds")) {
                    String finalValue = value;
                    Stream.of(ChatKeys.CHAT_KEYS_MOD_CATEGORY.getKeyBindings(), F3DebugKeys.F3_DEBUG_KEYS_CATEGORY.getKeyBindings()).toList().forEach(iNotEKKeybindings -> {
                        for (INotEKKeybinding keybinding : iNotEKKeybindings) {
                            if (!keybinding.method_1431().equals(translation)) continue;
                            keybinding.method_1422(class_3675.method_15981((String)finalValue));
                            break;
                        }
                    });
                }
            }
        });
        class_304.method_1426();
        class_304.method_1437();
        class_304.method_1424();
        PresetLoader.setCurrentPreset(preset);
        Utils.showToastNotification((class_2561)class_2561.method_43469((String)TextUtils.getTranslationKey("preset.load"), (Object[])new Object[]{preset.getName()}));
        NotEnoughKeybinds.LOGGER.info("Preset " + preset.getName() + " was loaded!");
    }

    public static void deletePreset(KeybindPreset preset) {
        File file = new File(PRESETS_DIR.getPath(), preset.getFileName());
        if (!file.delete()) {
            NotEnoughKeybinds.LOGGER.error("Could not delete preset file " + preset.getFileName());
        } else {
            NotEnoughKeybinds.LOGGER.info("Deleted preset " + preset.getFileName());
        }
        PresetLoader.reload(false);
    }

    public static void writePreset(KeybindPreset preset, File file) {
        try {
            PRESETS_DIR.mkdirs();
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            writer.write("version:" + CURRENT_VERSION);
            writer.newLine();
            writer.write("name:" + preset.name);
            writer.newLine();
            writer.write("description:" + preset.description);
            writer.newLine();
            preset.content.forEach(line -> {
                try {
                    writer.write((String)line);
                    writer.newLine();
                }
                catch (IOException e) {
                    NotEnoughKeybinds.LOGGER.error("Could not write " + line + " into " + file.getAbsolutePath());
                }
            });
            writer.close();
        }
        catch (IOException e) {
            NotEnoughKeybinds.LOGGER.error("Could not create file writer of file " + file.getAbsolutePath());
        }
    }

    public static void writePreset(KeybindPreset preset) {
        PresetLoader.writePreset(PresetLoader.addFileNameIf(preset), new File(PRESETS_DIR, preset.getFileName()));
    }

    public static void writePreset(KeybindPreset preset, List<String> content) {
        preset.setContent(content);
        PresetLoader.writePreset(PresetLoader.addFileNameIf(preset), new File(PRESETS_DIR, preset.getFileName()));
    }

    public static List<KeybindPreset> getPresets() {
        return presets.stream().toList();
    }

    public static String getCurrentPresetName() {
        return currentPreset == null ? NotEnoughKeybinds.GENERAL_CONFIG.currentPreset : currentPreset.getName();
    }

    public static KeybindPreset getCurrentPreset() {
        return currentPreset;
    }

    public static KeybindPreset addFileNameIf(KeybindPreset preset) {
        if (preset.getFileName().isEmpty()) {
            boolean found;
            int index = Objects.requireNonNull(PRESETS_DIR.listFiles()).length;
            block0: do {
                ++index;
                found = false;
                for (File file : Objects.requireNonNull(PRESETS_DIR.listFiles())) {
                    if (!file.getName().equals("preset" + index + ".txt")) continue;
                    found = true;
                    continue block0;
                }
            } while (found);
            preset.setFileName("preset" + index + ".txt");
        }
        return preset;
    }

    public static void setCurrentPreset(KeybindPreset preset) {
        currentPreset = preset;
        NotEnoughKeybinds.GENERAL_CONFIG.currentPreset = preset.getName();
        NotEKSettings.saveConfig();
    }

    public static class KeybindPreset {
        private String fileName = "";
        private float version;
        private String name;
        private String description;
        private List<String> content;

        public KeybindPreset(String fileName, float version, String name, String description, List<String> content) {
            this.fileName = fileName;
            this.version = version;
            this.name = name;
            this.description = description;
            this.content = content;
        }

        public KeybindPreset() {
            this.fileName = "";
            this.version = CURRENT_VERSION.floatValue();
            this.name = "";
            this.description = "";
            this.content = List.of();
        }

        public KeybindPreset(float version, String name, String description, List<String> content) {
            this.version = version;
            this.name = name;
            this.description = description;
            this.content = content;
        }

        public String getFileName() {
            return this.fileName;
        }

        public float getVersion() {
            return this.version;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public List<String> getContent() {
            return this.content;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public void setVersion(float version) {
            this.version = version;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setContent(List<String> content) {
            this.content = content;
        }

        public String toString() {
            return "KeybindPreset{fileName='" + this.fileName + "', version=" + this.version + ", name='" + this.name + "', description='" + this.description + "', content=" + String.valueOf(this.content) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeybindPreset that = (KeybindPreset)o;
            return Float.compare(that.version, this.version) == 0 && Objects.equals(this.fileName, that.fileName) && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.content, that.content);
        }

        public int hashCode() {
            return Objects.hash(this.fileName, Float.valueOf(this.version), this.name, this.description, this.content);
        }
    }
}

