/*
 * Decompiled with CFR 0.152.
 */
package net.sn0wix_.notEnoughKeybinds.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1740;
import net.minecraft.class_1781;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_490;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9284;
import net.minecraft.class_9285;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9701;
import net.minecraft.class_9890;
import net.sn0wix_.notEnoughKeybinds.NotEnoughKeybinds;

public class InventoryUtils {
    public static int getFireworkSlot(class_1661 inventory, boolean longestDuration, boolean canExplode) {
        int bestSlot = -1;
        int bestFlight = longestDuration ? -1 : Integer.MAX_VALUE;
        for (int slot = 0; slot < inventory.method_5439(); ++slot) {
            class_1799 stack = inventory.method_5438(slot);
            if (!(stack.method_7909() instanceof class_1781)) continue;
            class_9284 component = (class_9284)stack.method_57353().method_58694(class_9334.field_49616);
            if (!canExplode && !component.comp_2392().isEmpty()) continue;
            int newFlight = component.comp_2391();
            if (!(longestDuration ? newFlight > bestFlight : bestFlight != -1 && newFlight < bestFlight)) continue;
            bestFlight = newFlight;
            bestSlot = slot;
        }
        return bestSlot;
    }

    public static void switchInvHandSlot(class_310 client, class_1268 hand, int clickedSlot) {
        InventoryUtils.switchInvHotbarSlot(client, hand.equals((Object)class_1268.field_5810) ? 40 : client.field_1724.method_31548().method_67532(), clickedSlot);
    }

    public static void switchInvHotbarSlot(class_310 client, int hotbarSlot, int clickedSlot) {
        if (hotbarSlot > -1 && clickedSlot > -1) {
            assert (client.field_1724 != null);
            class_1703 handler = new class_490((class_1657)client.field_1724).method_17577();
            assert (client.field_1761 != null);
            client.field_1761.method_2906(handler.field_7763, InventoryUtils.convertSlotIds(clickedSlot), hotbarSlot, class_1713.field_7791, (class_1657)client.field_1724);
        }
    }

    public static void equipChestplate(class_310 client, int slot) {
        InventoryUtils.switchInvSlot(client, InventoryUtils.convertSlotIds(slot), 6, 0);
    }

    public static void switchInvSlot(class_310 client, int slot1, int slot2, int button) {
        assert (client.field_1724 != null);
        class_1703 handler = new class_490((class_1657)client.field_1724).method_17577();
        assert (client.field_1761 != null);
        client.field_1761.method_2906(handler.field_7763, slot1, button, class_1713.field_7790, (class_1657)client.field_1724);
        client.field_1761.method_2906(handler.field_7763, slot2, button, class_1713.field_7790, (class_1657)client.field_1724);
        client.field_1761.method_2906(handler.field_7763, slot1, button, class_1713.field_7790, (class_1657)client.field_1724);
    }

    public static int getBestBreakableItemSlot(class_1263 inventory, class_1792 item, int mendingScore) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (!stack.method_31574(item)) continue;
            class_2378 registryManager = class_310.method_1551().field_1687.method_30349().method_30530(class_7924.field_41265);
            int unbreakingLevel = class_1890.method_8225((class_6880)registryManager.method_46747(class_1893.field_9119), (class_1799)stack);
            int calculatedMendingScore = class_1890.method_8225((class_6880)registryManager.method_46747(class_1893.field_9101), (class_1799)stack) > 0 ? mendingScore : 0;
            int damageScore = (stack.method_7936() - stack.method_7919()) * (unbreakingLevel + 1);
            map.put(damageScore + calculatedMendingScore, i);
        }
        if (!map.isEmpty()) {
            Object[] scores = map.keySet().toArray(new Integer[0]);
            Arrays.sort(scores);
            return (Integer)map.get(scores[scores.length - 1]);
        }
        return -1;
    }

    public static void quickUseItem(class_310 client, int slot) {
        if (!class_1661.method_7380((int)slot)) {
            InventoryUtils.switchInvHandSlot(client, class_1268.field_5808, slot);
            InventoryUtils.interactItem(class_1268.field_5808, client);
            InventoryUtils.switchInvHandSlot(client, class_1268.field_5808, slot);
        } else {
            int slotBefore = client.field_1724.method_31548().method_67532();
            client.field_1724.method_31548().method_61496(slot);
            InventoryUtils.interactItem(class_1268.field_5808, client);
            client.field_1724.method_31548().method_61496(slotBefore);
        }
    }

    public static void interactItem(class_1268 hand, class_310 client) throws NullPointerException {
        class_1269.class_9860 swingSource;
        class_1269 class_12692 = client.field_1761.method_2919((class_1657)client.field_1724, hand);
        if (class_12692 instanceof class_1269.class_9860 && (swingSource = (class_1269.class_9860)class_12692).comp_2909() == class_1269.class_9861.field_52427) {
            client.field_1724.method_6104(hand);
        }
    }

    public static int getSlotWithChestplate(class_310 client) {
        int slot = -1;
        if (NotEnoughKeybinds.EQUIP_ELYTRA_CONFIG.chooseBestChestplate) {
            slot = InventoryUtils.getBestChestplateSlot((class_1263)client.field_1724.method_31548(), NotEnoughKeybinds.EQUIP_ELYTRA_CONFIG.acceptCurseOfVanishing, NotEnoughKeybinds.EQUIP_ELYTRA_CONFIG.acceptCurseOfBinding);
        } else {
            for (int i = 0; i < client.field_1724.method_31548().method_5439(); ++i) {
                try {
                    if (!InventoryUtils.isChestplate(client.field_1724.method_31548().method_5438(i))) continue;
                    slot = i;
                    break;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
        return slot;
    }

    public static int getSlotWithElytra(class_310 client) {
        return NotEnoughKeybinds.EQUIP_ELYTRA_CONFIG.chooseBestElytra ? InventoryUtils.getBestBreakableItemSlot((class_1263)client.field_1724.method_31548(), class_1802.field_8833, 216) : InventoryUtils.getSlotWithItem(class_1802.field_8833, client.field_1724.method_31548());
    }

    public static int getShieldSwapSlot(class_310 client) {
        return NotEnoughKeybinds.TOTEM_SHIELD_CONFIG.chooseBestShield ? InventoryUtils.getBestBreakableItemSlot((class_1263)client.field_1724.method_31548(), class_1802.field_8255, NotEnoughKeybinds.TOTEM_SHIELD_CONFIG.swapMendingPoints) : InventoryUtils.getSlotWithItem(class_1802.field_8255, client.field_1724.method_31548());
    }

    public static int getTotemSwapSlot(class_310 client, int lastShieldSlot) {
        return lastShieldSlot > -1 ? lastShieldSlot : InventoryUtils.getSlotWithItem(class_1802.field_8288, client.field_1724.method_31548());
    }

    public static int getBestChestplateSlot(class_1263 inventory, boolean acceptVanishing, boolean acceptBinding) {
        int bestArmorSlot = -1;
        float bestArmorStrength = -1.0f;
        int bestArmorDamage = Integer.MAX_VALUE;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack;
            if (inventory.method_5438(i).method_7960() || class_1890.method_60142((class_1799)(stack = inventory.method_5438(i)), (class_9331)class_9701.field_51656) && !acceptBinding || class_1890.method_60142((class_1799)stack, (class_9331)class_9701.field_51655) && !acceptVanishing) continue;
            try {
                if (!InventoryUtils.isChestplate(stack)) continue;
                float armorStrength = InventoryUtils.getFinalArmorStrength(stack);
                if (armorStrength > bestArmorStrength) {
                    bestArmorStrength = armorStrength;
                    bestArmorSlot = i;
                    bestArmorDamage = stack.method_7919();
                    continue;
                }
                if (armorStrength != bestArmorStrength || stack.method_7919() >= bestArmorDamage) continue;
                bestArmorDamage = stack.method_7919();
                bestArmorSlot = i;
                continue;
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        }
        return bestArmorSlot;
    }

    public static float getFinalArmorStrength(class_1799 itemStack) {
        float rating = InventoryUtils.getArmorRating(itemStack);
        class_2378 registryManager = class_310.method_1551().field_1687.method_30349().method_30530(class_7924.field_41265);
        rating += (float)class_1890.method_8225((class_6880)registryManager.method_46747(class_1893.field_9111), (class_1799)itemStack) * 1.25f;
        rating += (float)class_1890.method_8225((class_6880)registryManager.method_46747(class_1893.field_9124), (class_1799)itemStack) * 1.2f;
        rating += (float)class_1890.method_8225((class_6880)registryManager.method_46747(class_1893.field_9107), (class_1799)itemStack) * 1.2f;
        rating += (float)class_1890.method_8225((class_6880)registryManager.method_46747(class_1893.field_9111), (class_1799)itemStack) * 1.2f;
        rating += (float)class_1890.method_8225((class_6880)registryManager.method_46747(class_1893.field_9129), (class_1799)itemStack) * 0.33f;
        rating += (float)class_1890.method_8225((class_6880)registryManager.method_46747(class_1893.field_9097), (class_1799)itemStack) * 0.1f;
        return rating += (float)class_1890.method_8225((class_6880)registryManager.method_46747(class_1893.field_9119), (class_1799)itemStack) * 0.05f;
    }

    public static float getArmorRating(class_1799 itemStack) {
        float rating = 1.0f;
        try {
            Optional tagKey = ((class_9890)itemStack.method_58694(class_9334.field_53696)).comp_2939().method_45925();
            if (tagKey.isPresent()) {
                if (((class_6862)tagKey.get()).comp_327().equals((Object)class_1740.field_61364.comp_2301().comp_327())) {
                    rating = 2.0f;
                } else if (((class_6862)tagKey.get()).comp_327().equals((Object)class_1740.field_7895.comp_2301().comp_327())) {
                    rating = 2.0f;
                } else if (((class_6862)tagKey.get()).comp_327().equals((Object)class_1740.field_7887.comp_2301().comp_327())) {
                    rating = 3.0f;
                } else if (((class_6862)tagKey.get()).comp_327().equals((Object)class_1740.field_7892.comp_2301().comp_327())) {
                    rating = 4.0f;
                } else if (((class_6862)tagKey.get()).comp_327().equals((Object)class_1740.field_7889.comp_2301().comp_327())) {
                    rating = 5.0f;
                } else if (((class_6862)tagKey.get()).comp_327().equals((Object)class_1740.field_21977.comp_2301().comp_327())) {
                    rating = 6.0f;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return rating;
    }

    public static int convertSlotIds(int slot) {
        if (class_1661.method_7380((int)slot)) {
            slot += 36;
        } else if (slot == 40) {
            slot = 45;
        }
        return slot;
    }

    public static int getSlotWithItem(class_1792 item, class_1661 inventory) {
        for (int i = 0; i < inventory.method_67533().size(); ++i) {
            if (((class_1799)inventory.method_67533().get(i)).method_7960() || !((class_1799)inventory.method_67533().get(i)).method_31574(item)) continue;
            return i;
        }
        return -1;
    }

    public static boolean isChestplate(class_1799 itemStack) {
        AtomicBoolean bl = new AtomicBoolean(false);
        try {
            ((class_9285)itemStack.method_58694(class_9334.field_49636)).comp_2393().forEach(modifier -> {
                if (modifier.comp_2396().comp_2447().equals((Object)class_2960.method_60656((String)"armor.chestplate"))) {
                    bl.set(true);
                }
            });
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return bl.get();
    }
}

