/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.sodiumcoreshadersupport.mixin;

import java.util.function.IntFunction;
import net.caffeinemc.mods.sodium.client.gl.GlObject;
import net.caffeinemc.mods.sodium.client.gl.shader.GlProgram;
import net.caffeinemc.mods.sodium.client.gl.shader.uniform.GlUniform;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL20C;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.gen.Accessor;

@Mixin(value={GlProgram.class})
public abstract class MixinGLProgram
extends GlObject {
    @Accessor(value="LOGGER", remap=false)
    abstract Logger getLOGGER();

    @Overwrite(remap=false)
    @NotNull
    public <U extends GlUniform<?>> U bindUniform(String name, IntFunction<U> factory) {
        int index = GL20C.glGetUniformLocation((int)this.handle(), (CharSequence)name);
        if (index < 0) {
            int error = GL20C.glGetError();
            if (error == 1282) {
                this.getLOGGER().warn("Error while binding uniform: GL_INVALID_OPERATION");
            } else if (error == 1281) {
                this.getLOGGER().warn("Error while binding uniform: GL_INVALID_VALUE");
            } else {
                this.getLOGGER().warn("Error while binding uniform: Unknown Error, code: " + error);
            }
        }
        return (U)((GlUniform)factory.apply(index));
    }
}

