package de.linusdev.sodiumcoreshadersupport.mixin.client;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import static de.linusdev.sodiumcoreshadersupport.SodiumCoreShaderSupportClient.isResourcePackCompatible;

import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_3288;
import net.minecraft.class_410;
import net.minecraft.class_521;
import net.minecraft.class_5369;


@Mixin(class_521.class_4271.class)
public abstract class MixinResourcePackEntry {


    @Shadow @Final private class_5369.class_5371 pack;
    @Shadow @Final protected class_310 minecraft;
    @Shadow @Final private class_521 parent;

    @Inject(at = @At("HEAD"), method = "handlePackSelection", cancellable = true)
    private void enable(CallbackInfo ci) {

        class_3288 resProfile = ((MixinAbstractPack) pack).getPack();

        var ret = isResourcePackCompatible(resProfile);
        switch (ret.compatibility()) {
            case COMPATIBLE -> {
                // Do nothing, pack can be enabled.
            }
            case NOT_COMPATIBLE -> {
                String title = "Compatible minecraft versions:";
                assert ret.minecraftVersions() != null;
                String msg = ret.minecraftVersions().stream().reduce((string, string2) -> string + ", " + string2).orElse("none");

                if(ret.correctMcVersionIndex() != null) {
                    title = "Compatible sodium versions for current minecraft version:";
                    assert ret.sodiumVersions() != null;
                    var sMsg = ret.sodiumVersions().stream().reduce((string, string2) -> string + ", " + string2);
                    msg = sMsg.orElseGet(() ->
                            ret.minecraftVersions().stream()
                                    .filter(string -> !string.equals(ret.minecraftVersions().get(ret.correctMcVersionIndex())))
                                    .reduce((string, string2) -> string + ", " + string2)
                                    .orElse("none")
                    );
                }

                this.minecraft.method_1507(new class_410(
                        confirmed -> {
                            this.minecraft.method_1507(((MixinPackListWidget) this.parent).getScreen());
                            if (confirmed) {
                                this.pack.method_29656();
                            }
                        },
                        class_2561.method_30163("Resourcepack not compatible with current sodium or minecraft version."),
                        class_2561.method_30163(title + " " + msg),
                        class_2561.method_43470("Enable Anyway").method_10862(class_2583.field_24360.method_36139(0xff0000)),
                        class_2561.method_30163("OK")
                ));

                ci.cancel();
            }
            case MISSING_INFORMATION -> {
                this.minecraft.method_1507(new class_410(
                        confirmed -> {
                            this.minecraft.method_1507(((MixinPackListWidget) this.parent).getScreen());
                            if (confirmed) {
                                this.pack.method_29656();
                            }
                        },
                        class_2561.method_30163("Warning"),
                        class_2561.method_30163("This resourcepack overwrites shaders, but does not specify compatibility with sodium core shaders. It is most likely not compatible. Do you want to enable it anyway?")

                ));

                ci.cancel();
            }
            case MALFORMED_INFORMATION -> {
                this.minecraft.method_1507(new class_410(
                        confirmed -> {
                            this.minecraft.method_1507(((MixinPackListWidget) this.parent).getScreen());
                            if (confirmed) {
                                this.pack.method_29656();
                            }
                        },
                        class_2561.method_30163("Warning"),
                        class_2561.method_30163("This resourcepack contains malformed information about its compatibility (see log). Do you want to enable it anyway?")
                ));

                ci.cancel();
            }
        }
    }


}
