package de.linusdev.sodiumcoreshadersupport.mixin.client;


import net.caffeinemc.mods.sodium.client.gl.shader.GlShader;
import net.caffeinemc.mods.sodium.client.gl.shader.ShaderConstants;
import net.caffeinemc.mods.sodium.client.gl.shader.ShaderLoader;
import net.caffeinemc.mods.sodium.client.gl.shader.ShaderType;
import net.minecraft.class_2960;
import org.apache.commons.io.IOUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

import static de.linusdev.sodiumcoreshadersupport.Constants.LOG;
import static de.linusdev.sodiumcoreshadersupport.SodiumCoreShaderSupportClient.shaders;

@Mixin(ShaderLoader.class)
public class MixinShaderLoader {

    @Inject(at = @At("HEAD"), method = "loadShader")
    private static void loadShaderInject(
            ShaderType type, class_2960 name, ShaderConstants constants, CallbackInfoReturnable<GlShader> cir
    ) {
        LOG.info("Start loading shader in namespace '"  + name.method_12836() + "': " + name.method_12832());
    }

    /**
     * @author LinusDev
     * @reason Load shaders from resources, loaded by then ResourceManager instead of reading them as java resource.
     */
    @Overwrite
    public static String getShaderSource(class_2960 name) {

        if(shaders == null) {
            LOG.warn("Trying to load shaders, but shaders variable not yet initialised");
            // fallback to default getShaderSource
            String path = String.format("/assets/%s/shaders/%s", name.method_12836(), name.method_12832());

            try (InputStream in = ShaderLoader.class.getResourceAsStream(path)) {
                if (in == null) {
                    throw new RuntimeException("Shader not found: " + path);
                } else {
                    return IOUtils.toString(in, StandardCharsets.UTF_8);
                }
            } catch (IOException e) {
                throw new RuntimeException("Failed to read shader source for " + path, e);
            }
        }

        var nameSpace = shaders.get(name.method_12836());

        if(nameSpace == null)
            throw new RuntimeException("No Shaders available for namespace '" + name.method_12836() + "'");

        var shaderResource = nameSpace.get(name.method_12832());

        if(shaderResource == null)
            throw new RuntimeException("No Shader found in namespace '" + name.method_12836()
                    + "' for shader '" + name.method_12832() + "'");

        try {

            //noinspection resource: This would close the pack which is not what we want.
            LOG.info("Loaded Shader '{}:{}' from pack '{}'.", name.method_12836(), name.method_12832(), shaderResource.method_45304().method_56926().comp_2330().getString());


            return IOUtils.toString(shaderResource.method_14482(), StandardCharsets.UTF_8);
        } catch (IOException e) {
            throw new RuntimeException("Exception while reading shader source in namespace '" + name.method_12836()
                    + "' for shader '" + name.method_12832() + "'", e);
        }
    }

}