package de.linusdev.sodiumcoreshadersupport;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import de.linusdev.sodiumcoreshadersupport.mixin.client.MixinPack;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.resource.v1.ResourceLoader;
import net.fabricmc.fabric.api.resource.v1.reloader.SimpleResourceReloader;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_155;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3288;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_6489;
import net.minecraft.class_7367;
import org.jetbrains.annotations.NotNull;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

import static de.linusdev.sodiumcoreshadersupport.Constants.RELOAD_LISTENER_ID;

public class SodiumCoreShaderSupportClient implements ClientModInitializer {
	@Override
	public void onInitializeClient() {
        ResourceLoader.get(class_3264.field_14188).registerReloader(
                class_2960.method_60655(RELOAD_LISTENER_ID.method_12836(), RELOAD_LISTENER_ID.method_12832()),
                new SimpleResourceReloader<@NotNull String>() {
                    @Override
                    protected String prepare(@NotNull class_11558 store) {
                        reloadShaders(store.method_72361());
                        return "";
                    }

                    @Override
                    protected void apply(String prepared, @NotNull class_11558 store) {

                    }
                }
        );
	}

    public static Map<String, Map<String, class_3298>> shaders;

    public static void reloadShaders(@NotNull class_3300 manager) {
        Constants.LOG.info("Loading shaders...");
        shaders = new HashMap<>();

        manager.method_41265("shaders", path -> true).forEach((identifier, resources) -> {
            Map<String, class_3298> nameSpace = shaders.computeIfAbsent(
                    identifier.method_12836(),
                    k -> new HashMap<>()
            );

            nameSpace.put(
                    identifier.method_12832().substring("shaders/".length()),
                    resources.getLast()
            );
        });

        shaders.forEach((nameSpace, map) -> {
            System.out.println("nameSpace: " + nameSpace);
            map.forEach((path, resource) -> {
                //noinspection resource: This would close the pack which is not what we want.
                System.out.println("    " + path + ": " + resource.method_45304().method_56926().comp_2330().getString());
            });
        });
    }

    public static PackSodiumCompReturn isResourcePackCompatible(class_3288 resProfile) {
        Constants.LOG.info("Checking resourcepack compatibility to sodium");
        if(!FabricLoader.getInstance().isModLoaded(Constants.SODIUM_MOD_ID)) {
            Constants.LOG.info("Sodium not loaded -> COMPATIBLE");
            return new PackSodiumCompReturn(PackSodiumCompatibility.COMPATIBLE, null, null, null); // sodium is not installed
        }

        class_6489 currentGameVersion = class_155.method_16673();
        String sodiumVersion = FabricLoader.getInstance().getModContainer(Constants.SODIUM_MOD_ID).orElseThrow().getMetadata().getVersion().toString();

        var resourceSupplier = ((MixinPack) resProfile).getResourceSupplier();

        List<String> sodiumVersions = new ArrayList<>();
        List<String> minecraftVersions = new ArrayList<>();
        Integer correctMcVersionIndex = null;
        int mcVersionIndex = 0;
        try (var res = resourceSupplier.method_52424(resProfile.method_56933())) {

            // Check if pack has shaders
            AtomicBoolean hasShaders = new AtomicBoolean(false);
            res.method_14408(class_3264.field_14188, "minecraft", "shaders", (identifier, inputStreamInputSupplier) -> {
                hasShaders.set(true);
            });

            if(!hasShaders.get()) {
                // No shaders in the pack, it is compatible
                Constants.LOG.info("Pack does not contain shaders -> COMPATIBLE");
                return new PackSodiumCompReturn(PackSodiumCompatibility.COMPATIBLE, null, null, null);
            }


            // Check if pack has versions info
            class_7367<InputStream> streamSup = res.method_14405(class_3264.field_14188, class_2960.method_60655("sodiumcoreshadersupport", "versions.json"));

            if(streamSup == null) {
                // No info, show warning
                Constants.LOG.info("Pack does not contain a versions.json -> MISSING_INFORMATION");
                return new PackSodiumCompReturn(PackSodiumCompatibility.MISSING_INFORMATION, null, null, null);
            }

            // read json
            try(BufferedReader reader = new BufferedReader(new InputStreamReader(streamSup.get(), StandardCharsets.UTF_8))) {
                JsonElement element = JsonParser.parseReader(reader);
                if (element == null || !element.isJsonObject()) {
                    Constants.LOG.warn("{} has an invalid versions.json: first element must be json object ({...}) -> MALFORMED_INFORMATION", resProfile.method_14463());
                    return new PackSodiumCompReturn(PackSodiumCompatibility.MALFORMED_INFORMATION, null, null, null);
                }

                element = element.getAsJsonObject().get("supported-versions");

                if (element == null || !element.isJsonObject()) {
                    Constants.LOG.warn("{} has an invalid versions.json: missing 'supported-versions' json element -> MALFORMED_INFORMATION", resProfile.method_14463());
                    return new PackSodiumCompReturn(PackSodiumCompatibility.MALFORMED_INFORMATION, null, null, null);
                }

                for (Map.Entry<String, JsonElement> entry : element.getAsJsonObject().asMap().entrySet()) {
                    if (!entry.getValue().isJsonArray()) {
                        Constants.LOG.warn("{} has an invalid versions.json: sodium versions must be specified as array -> MALFORMED_INFORMATION", resProfile.method_14463());
                        return new PackSodiumCompReturn(PackSodiumCompatibility.MALFORMED_INFORMATION, null, null, null);
                    }

                    minecraftVersions.add(entry.getKey());
                    if (entry.getKey().equals(currentGameVersion.comp_4025())) {
                        correctMcVersionIndex = mcVersionIndex;
                        for (JsonElement ele : entry.getValue().getAsJsonArray()) {
                            if (!ele.isJsonPrimitive() || !ele.getAsJsonPrimitive().isString()) {
                                Constants.LOG.warn("{} has an invalid versions.json: sodium versions array must contain strings -> MALFORMED_INFORMATION", resProfile.method_14463());
                                return new PackSodiumCompReturn(PackSodiumCompatibility.MALFORMED_INFORMATION, null, null, null);
                            }

                            sodiumVersions.add(ele.getAsJsonPrimitive().getAsString());
                            if (sodiumVersion.equals(ele.getAsJsonPrimitive().getAsString())) {
                                // match found
                                Constants.LOG.info("pack is COMPATIBLE!");
                                return new PackSodiumCompReturn(PackSodiumCompatibility.COMPATIBLE, null, null, null);
                            }
                        }
                        break;
                    }
                    mcVersionIndex++;
                }
            }

        } catch (IOException e) {
            throw new RuntimeException(e);
        }

        Constants.LOG.info("No version match found -> NOT_COMPATIBLE!");
        return new PackSodiumCompReturn(PackSodiumCompatibility.NOT_COMPATIBLE, sodiumVersions, minecraftVersions, correctMcVersionIndex); // no match found

    }
}