package de.linusdev.sodiumcoreshadersupport.mixin.client;

import net.caffeinemc.mods.sodium.client.gl.shader.uniform.GlUniformFloat;
import net.caffeinemc.mods.sodium.client.render.chunk.shader.ChunkShaderOptions;
import net.caffeinemc.mods.sodium.client.render.chunk.shader.DefaultShaderInterface;
import net.caffeinemc.mods.sodium.client.render.chunk.shader.ShaderBindingContext;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import net.caffeinemc.mods.sodium.client.util.FogParameters;
import net.minecraft.class_12137;
import net.minecraft.class_310;
import net.minecraft.class_9779;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(DefaultShaderInterface.class)
public abstract class MixinDefaultShaderInterface {

    @Unique
    private GlUniformFloat sodiumCoreShaderSupport$uniformGameTime = null;

    @Inject(
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/caffeinemc/mods/sodium/client/render/chunk/shader/ShaderBindingContext;bindUniform(Ljava/lang/String;Ljava/util/function/IntFunction;)Lnet/caffeinemc/mods/sodium/client/gl/shader/uniform/GlUniform;",
                    shift = At.Shift.AFTER
            ),
            method = "<init>",
            remap = false
    )
    private void injectConstructor(ShaderBindingContext context, ChunkShaderOptions options, CallbackInfo ci) {
        sodiumCoreShaderSupport$uniformGameTime = context.bindUniformOptional("u_GameTime", GlUniformFloat::new);
    }

    @Inject(at = @At("RETURN"), method = "setupState", remap = false)
    private void injectSetupState(TerrainRenderPass pass, FogParameters parameters, class_12137 terrainSampler, CallbackInfo ci) {
        class_310 minecraft = class_310.method_1551();
        long time = minecraft.field_1687 == null ? 0L : minecraft.field_1687.method_75260();
        class_9779 deltaTracker = minecraft.method_61966();
        if(sodiumCoreShaderSupport$uniformGameTime != null)
            sodiumCoreShaderSupport$uniformGameTime.set(
                    ((float)(time % 24000L) + deltaTracker.method_60637(false)) / 24000.0F
            );
    }

}