/*
 * Decompiled with CFR 0.152.
 */
package org.omegaconfig;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.TypeVariable;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.omegaconfig.api.annotations.Spec;

public class Tools {
    public static Class<?> toPrimitive(Class<?> clazz) {
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Character.class) {
            return Character.TYPE;
        }
        return clazz;
    }

    public static Class<?> toBoxed(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        return clazz;
    }

    public static Spec specOfWeak(Class<?> c) {
        return c.getAnnotation(Spec.class);
    }

    public static Spec specOf(Class<?> c) {
        Spec spec = Tools.specOfWeak(c);
        if (spec == null) {
            throw new IllegalArgumentException("Class '" + c.getName() + "' has no Spec annotation");
        }
        return spec;
    }

    public static Spec.Field specFieldOf(Field field) {
        return field.getAnnotation(Spec.Field.class);
    }

    public static Class<?> typeOf(Field field) {
        return Tools.toBoxed(field.getType());
    }

    public static Class<?> subTypeOf(Field field) {
        Class<?> type = Tools.typeOf(field);
        if (type.isArray()) {
            return type.getComponentType();
        }
        TypeVariable<Class<?>>[] types = type.getTypeParameters();
        if (types.length == 0) {
            return null;
        }
        if (types.length == 1) {
            return types[0].getClass();
        }
        throw new IllegalArgumentException("Class has more than 2 type arguments");
    }

    public static String concat(String prefix, String suffix, char key, Collection<String> strings) {
        StringBuilder result = new StringBuilder(strings.size() * 8 + 16);
        result.append(prefix);
        Iterator<String> it = strings.iterator();
        while (it.hasNext()) {
            result.append(it.next());
            if (!it.hasNext()) continue;
            result.append(key);
        }
        result.append(suffix);
        return result.toString();
    }

    public static String concat(String prefix, String suffix, char key, String ... strings) {
        return Tools.concat(prefix, suffix, key, Arrays.asList(strings));
    }

    public static void closeQuietly(Closeable in) {
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static <T> T valueFrom(Field field, Object context) {
        try {
            Object result = field.get(context);
            if (result == null) {
                throw new NullPointerException("Field its empty");
            }
            return (T)result;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to validate field" + (String)(field != null ? " " + field.getName() : " because it's null"), e);
        }
    }

    public static <T> void setFieldValue(Field field, Object context, T value) {
        try {
            field.set(context, value);
        }
        catch (ReflectiveOperationException e) {
            Tools.throwUpdateValueException(field, e);
        }
    }

    public static void setFieldValue(Field field, Object context, byte byteValue) {
        try {
            field.setByte(context, byteValue);
        }
        catch (ReflectiveOperationException e) {
            Tools.throwUpdateValueException(field, e);
        }
    }

    public static void setFieldValue(Field field, Object context, short shortValue) {
        try {
            field.setShort(context, shortValue);
        }
        catch (ReflectiveOperationException e) {
            Tools.throwUpdateValueException(field, e);
        }
    }

    public static void setFieldValue(Field field, Object context, int intValue) {
        try {
            field.setInt(context, intValue);
        }
        catch (ReflectiveOperationException e) {
            Tools.throwUpdateValueException(field, e);
        }
    }

    public static void setFieldValue(Field field, Object context, long longValue) {
        try {
            field.setLong(context, longValue);
        }
        catch (ReflectiveOperationException e) {
            Tools.throwUpdateValueException(field, e);
        }
    }

    public static void setFieldValue(Field field, Object context, float floatValue) {
        try {
            field.setFloat(context, floatValue);
        }
        catch (ReflectiveOperationException e) {
            Tools.throwUpdateValueException(field, e);
        }
    }

    public static void setFieldValue(Field field, Object context, double byteValue) {
        try {
            field.setDouble(context, byteValue);
        }
        catch (ReflectiveOperationException e) {
            Tools.throwUpdateValueException(field, e);
        }
    }

    public static void setFieldValue(Field field, Object context, char charValue) {
        try {
            field.setChar(context, charValue);
        }
        catch (ReflectiveOperationException e) {
            Tools.throwUpdateValueException(field, e);
        }
    }

    public static void throwUpdateValueException(Field field, Exception e) {
        throw new IllegalStateException("Failed to set new value to field '" + field.getName() + "'", e);
    }

    public static boolean contains(char c, char[] expected) {
        for (char e : expected) {
            if (c != e) continue;
            return true;
        }
        return false;
    }

    public static byte[] readAllBytes(Path path) throws IOException {
        try (FileInputStream in = new FileInputStream(path.toFile());){
            byte[] byArray = in.readAllBytes();
            return byArray;
        }
    }

    public static boolean requireNotNull(Object[] parsedValues) {
        for (Object value : parsedValues) {
            if (value != null) continue;
            return false;
        }
        return true;
    }
}

