/*
 * Decompiled with CFR 0.152.
 */
package org.omegaconfig.api;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.omegaconfig.ConfigGroup;
import org.omegaconfig.ConfigSpec;

public interface IConfigField<T, S>
extends Consumer<T>,
Supplier<T> {
    default public String id() {
        ConfigGroup group = this.group();
        String name = this.name();
        String parentName = group != null ? group.id() + "." : "";
        return parentName + name + (group != null ? "" : ":");
    }

    public String name();

    public ConfigSpec spec();

    public ConfigGroup group();

    default public int groupCount() {
        int count = 0;
        for (ConfigGroup g = this.group(); g != null; g = g.group()) {
            ++count;
        }
        return count;
    }

    public Class<T> type();

    public Class<S> subType();

    public String[] comments();

    public void reset();

    public boolean reflected();

    public void validate();

    default public void set0(Object object) {
        if (object == null) {
            this.reset();
        } else {
            this.accept(object);
            this.validate();
        }
    }

    default public void set(T value) {
        this.accept(value);
    }
}

