/*
 * Decompiled with CFR 0.152.
 */
package org.omegaconfig.impl.fields;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Predicate;
import org.omegaconfig.ConfigGroup;
import org.omegaconfig.impl.fields.CollectionField;

public class ArrayField<T>
extends CollectionField<T[], T> {
    public ArrayField(String name, ConfigGroup group, Set<String> comments, boolean stringify, boolean singleline, boolean allowEmpty, boolean unique, int limit, Class<? extends Predicate<T>> filter, Field field, Object context, Class<T> subType) {
        super(name, group, comments, stringify, singleline, allowEmpty, unique, limit, filter, field, context, subType);
    }

    public ArrayField(String name, ConfigGroup group, Set<String> comments, boolean stringify, boolean singleline, boolean allowEmpty, boolean unique, int limit, Class<? extends Predicate<T>> filter, T[] defaultValue, Class<T> subType) {
        super(name, group, comments, stringify, singleline, allowEmpty, unique, limit, filter, defaultValue, subType);
    }

    @Override
    public CollectionField<T[], T> setArray(Object[] array) {
        Object[] fresh = (Object[])Array.newInstance(this.subType, array.length);
        for (int i = 0; i < array.length; ++i) {
            if (!this.subType.isInstance(array[i])) {
                throw new IllegalArgumentException("Array contains elements not of type " + this.subType.getName());
            }
            fresh[i] = this.subType.cast(array[i]);
        }
        this.set(fresh);
        return this;
    }

    public ArrayField<T> add(T element) {
        Object[] current = (Object[])this.get();
        if (current == null || current.length == 0) {
            this.set((Object[])Array.newInstance(this.subType, 1));
            ((Object[])this.get())[0] = element;
        } else {
            Object[] newArray = (Object[])Array.newInstance(this.subType, current.length + 1);
            System.arraycopy(current, 0, newArray, 0, current.length);
            newArray[current.length] = element;
            this.set(newArray);
        }
        return this;
    }

    public ArrayField<T> remove(T element) {
        Object[] current = (Object[])this.get();
        if (current == null || current.length == 0) {
            return this;
        }
        int index = -1;
        for (int i = 0; i < current.length; ++i) {
            if (current[i] != element && !current[i].equals(element)) continue;
            index = i;
            break;
        }
        if (index != -1) {
            Object[] newArray = (Object[])Array.newInstance(this.subType, current.length - 1);
            System.arraycopy(current, 0, newArray, 0, index);
            System.arraycopy(current, index + 1, newArray, index, current.length - index - 1);
            this.set(newArray);
        }
        return this;
    }

    @Override
    public T remove(int index) {
        Object[] current = (Object[])this.get();
        if (current == null || index < 0 || index >= current.length) {
            return null;
        }
        Object removedElement = current[index];
        if (current.length == 1) {
            this.clear();
        } else {
            Object[] newArray = (Object[])Array.newInstance(this.subType, current.length - 1);
            System.arraycopy(current, 0, newArray, 0, index);
            System.arraycopy(current, index + 1, newArray, index, current.length - index - 1);
            this.set(newArray);
        }
        return (T)removedElement;
    }

    @Override
    public boolean contains(T element) {
        for (Object item : (Object[])this.get()) {
            if (item != element && !item.equals(element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return ((Object[])this.get()).length;
    }

    public ArrayField<T> clear() {
        this.set((Object[])Array.newInstance(this.subType, 0));
        return this;
    }

    @Override
    public Class<T[]> type() {
        return ((Object[])this.defaultValue).getClass();
    }

    @Override
    public void validate() {
        if (this.get() == null || ((Object[])this.get()).length == 0) {
            if (!this.allowEmpty) {
                this.reset();
            }
            return;
        }
        if (this.unique && (long)((Object[])this.get()).length != Arrays.stream((Object[])this.get()).distinct().count()) {
            A[] distinctArray = Arrays.stream((Object[])this.get()).distinct().toArray(size -> (Object[])Array.newInstance(this.subType, size));
            this.set(distinctArray);
            return;
        }
        if (this.limit > 0 && ((Object[])this.get()).length > this.limit) {
            A[] truncatedArray = Arrays.stream((Object[])this.get()).distinct().limit(this.limit).toArray(size -> (Object[])Array.newInstance(this.subType, size));
            this.set(truncatedArray);
        }
    }
}

