/*
 * Decompiled with CFR 0.152.
 */
package org.omegaconfig.impl.fields;

import java.lang.reflect.Field;
import java.util.Set;
import java.util.function.IntSupplier;
import org.omegaconfig.ConfigGroup;
import org.omegaconfig.impl.fields.BaseNumberField;

public final class ByteField
extends BaseNumberField<Byte>
implements IntSupplier {
    public final byte min;
    public final byte max;
    private byte primitive;

    public ByteField(String name, ConfigGroup group, Set<String> comments, boolean math, boolean strictMath, byte min, byte max, Field field, Object context) {
        super(name, group, comments, math, strictMath, field, context);
        this.primitive = (Byte)this.defaultValue;
        this.min = min;
        this.max = max;
    }

    public ByteField(String name, ConfigGroup group, Set<String> comments, boolean math, boolean strictMath, byte min, byte max, Byte defaultValue) {
        super(name, group, comments, math, strictMath, defaultValue);
        this.primitive = (Byte)this.defaultValue;
        this.min = min;
        this.max = max;
    }

    @Override
    public Class<Byte> type() {
        return Byte.class;
    }

    @Override
    public void accept(Byte value) {
        this.primitive = value;
        super.accept(this.primitive);
    }

    @Override
    public int getAsInt() {
        return this.primitive;
    }

    public byte getAsByte() {
        return this.primitive;
    }

    @Override
    public void validate() {
        if (this.primitive < this.min || this.primitive > this.max) {
            this.reset();
        }
    }

    @Override
    public String minValueString() {
        return this.min == -128 ? null : String.valueOf(this.min);
    }

    @Override
    public String maxValueString() {
        return this.max == 127 ? null : String.valueOf(this.max);
    }
}

