/*
 * Decompiled with CFR 0.152.
 */
package org.omegaconfig.impl.fields;

import java.lang.reflect.Field;
import java.util.Set;
import java.util.function.DoubleSupplier;
import org.omegaconfig.ConfigGroup;
import org.omegaconfig.impl.fields.BaseNumberField;

public final class DoubleField
extends BaseNumberField<Double>
implements DoubleSupplier {
    public final double min;
    public final double max;
    private double primitive;

    public DoubleField(String name, ConfigGroup group, Set<String> comments, boolean math, boolean strictMath, double min, double max, Field field, Object context) {
        super(name, group, comments, math, strictMath, field, context);
        this.primitive = (Double)this.defaultValue;
        this.min = min;
        this.max = max;
    }

    public DoubleField(String name, ConfigGroup group, Set<String> comments, boolean math, boolean strictMath, double min, double max, Double defaultValue) {
        super(name, group, comments, math, strictMath, defaultValue);
        this.primitive = (Double)this.defaultValue;
        this.min = min;
        this.max = max;
    }

    @Override
    public Class<Double> type() {
        return Double.class;
    }

    @Override
    public void validate() {
        if (this.primitive < this.min || this.primitive > this.max) {
            this.reset();
        }
    }

    @Override
    public void accept(Double value) {
        this.primitive = value;
        super.accept(this.primitive);
    }

    @Override
    public double getAsDouble() {
        return this.primitive;
    }

    @Override
    public String minValueString() {
        return this.min == Double.MIN_VALUE ? null : String.valueOf(this.min);
    }

    @Override
    public String maxValueString() {
        return this.max == Double.MAX_VALUE ? null : String.valueOf(this.max);
    }
}

