/*
 * Decompiled with CFR 0.152.
 */
package org.omegaconfig.impl.fields;

import java.lang.reflect.Field;
import java.util.Set;
import java.util.function.LongSupplier;
import org.omegaconfig.ConfigGroup;
import org.omegaconfig.impl.fields.BaseNumberField;

public final class LongField
extends BaseNumberField<Long>
implements LongSupplier {
    public final long min;
    public final long max;
    private long primitive;

    public LongField(String name, ConfigGroup group, Set<String> comments, boolean math, boolean strictMath, long min, long max, Field field, Object context) {
        super(name, group, comments, math, strictMath, field, context);
        this.primitive = (Long)this.defaultValue;
        this.min = min;
        this.max = max;
    }

    public LongField(String name, ConfigGroup group, Set<String> comments, boolean math, boolean strictMath, long min, long max, Long defaultValue) {
        super(name, group, comments, math, strictMath, defaultValue);
        this.primitive = (Long)this.defaultValue;
        this.min = min;
        this.max = max;
    }

    @Override
    public Class<Long> type() {
        return Long.class;
    }

    @Override
    public void validate() {
        if (this.primitive < this.min || this.primitive > this.max) {
            this.reset();
        }
    }

    @Override
    public void accept(Long value) {
        this.primitive = value;
        super.accept(this.primitive);
    }

    @Override
    public long getAsLong() {
        return this.primitive;
    }

    @Override
    public String minValueString() {
        return this.min == Long.MIN_VALUE ? null : String.valueOf(this.min);
    }

    @Override
    public String maxValueString() {
        return this.max == Long.MAX_VALUE ? null : String.valueOf(this.max);
    }
}

