/*
 * Decompiled with CFR 0.152.
 */
package org.omegaconfig.impl.formats;

import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import org.omegaconfig.Tools;
import org.omegaconfig.api.formats.IFormatCodec;
import org.omegaconfig.api.formats.IFormatReader;
import org.omegaconfig.api.formats.IFormatWriter;

public class JSONFormat
implements IFormatCodec {
    private static final char JSON_OBJECT_START = '{';
    private static final char JSON_OBJECT_END = '}';
    private static final char JSON_CONTINUE = ',';
    private static final char JSON_STRING_LINE = '\"';
    private static final char JSON_ENTRY_SPLIT = ':';
    private static final char JSON_ARRAY_START = '[';
    private static final char JSON_ARRAY_END = ']';
    private static final char JSON_ESCAPED = '\\';

    @Override
    public String id() {
        return "json";
    }

    @Override
    public String extension() {
        return "." + this.id();
    }

    @Override
    public String mimeType() {
        return "application/json";
    }

    @Override
    public IFormatReader createReader(Path filePath) throws IOException {
        return new FormatReader(filePath);
    }

    @Override
    public IFormatWriter createWritter(Path filePath) throws IOException {
        return new FormatWriter(filePath);
    }

    public static class FormatReader
    implements IFormatReader {
        public static final char[] START_CHARS = new char[]{'{'};
        public static final char[] KEY_OR_END = new char[]{'\"', '}'};
        public static final char[] CONTINUE_OR_END = new char[]{',', '}'};
        public static final char[] CONTINUE_OR_ARRAY_END = new char[]{',', ']'};
        public static final char[] SPLIT = new char[]{':'};
        public static final int NONE = 0;
        public static final int KEY = 1;
        public static final int VALUE = 2;
        public static final int VALUE_STRING = 3;
        public static final int ARRAY = 4;
        public static final int ARRAY_STRING = 5;
        public final LinkedHashMap<String, Object> values = new LinkedHashMap<K, V>();
        public final Stack<String> group = new Stack<E>();
        public final StringBuilder key = new StringBuilder();
        public final StringBuilder value = new StringBuilder();
        public final List<String> arrayValues = new ArrayList<String>();
        public boolean escaped;
        public boolean finished = false;

        /*
         * Unable to fully structure code
         */
        public FormatReader(Path path) throws IOException {
            super();
            data = new String(Tools.readAllBytes(path), StandardCharsets.UTF_8).toCharArray();
            nexts = FormatReader.START_CHARS;
            capturing = 0;
            block15: for (char c : data) {
                whitespace = Character.isWhitespace(c);
                if (whitespace && (capturing != 3 && capturing != 1 && capturing != 5 || capturing == 5 && nexts != null)) continue;
                if (this.finished) {
                    throw new EOFException("Reached end of JSON spec but file still contains data");
                }
                if (nexts != null && !Tools.contains(c, nexts)) {
                    throw new IllegalStateException("Expected char(s) " + Arrays.toString(nexts) + " but received " + c);
                }
                switch (c) {
                    case '{': {
                        if (capturing == 2) {
                            this.pushGroup();
                            capturing = 0;
                        }
                        nexts = FormatReader.KEY_OR_END;
                        continue block15;
                    }
                    case '[': {
                        if (capturing != 1 && capturing != 3) {
                            capturing = 4;
                            continue block15;
                        }
                        ** GOTO lbl101
                    }
                    case '\"': {
                        if (!this.escaped || capturing != 1 && capturing != 3) {
                            if (capturing == 5) {
                                this.putArrayValue();
                                nexts = FormatReader.CONTINUE_OR_ARRAY_END;
                                continue block15;
                            }
                            if (capturing == 4) {
                                capturing = 5;
                                nexts = null;
                                continue block15;
                            }
                            if (capturing == 3) {
                                capturing = 0;
                                this.putEntry(false);
                                nexts = FormatReader.CONTINUE_OR_END;
                                continue block15;
                            }
                            if (capturing == 2) {
                                capturing = 3;
                                nexts = null;
                                continue block15;
                            }
                            if (capturing == 1) {
                                capturing = 0;
                                nexts = FormatReader.SPLIT;
                                continue block15;
                            }
                            capturing = 1;
                            nexts = null;
                            continue block15;
                        }
                        ** GOTO lbl101
                    }
                    case '\\': {
                        this.escaped = true;
                        continue block15;
                    }
                    case ':': {
                        if (capturing != 1 && capturing != 3) {
                            capturing = 2;
                            nexts = null;
                            continue block15;
                        }
                        ** GOTO lbl101
                    }
                    case ',': {
                        if (capturing != 1 && capturing != 3) {
                            if (capturing == 2) {
                                this.putEntry(false);
                                capturing = 0;
                                this.clear();
                            }
                            if (capturing == 5) {
                                capturing = 4;
                                nexts = new char[]{'\"', ']'};
                                continue block15;
                            }
                            if (capturing == 4) {
                                this.putArrayValue();
                                nexts = null;
                                continue block15;
                            }
                            nexts = new char[]{'\"', '}'};
                            continue block15;
                        }
                        ** GOTO lbl101
                    }
                    case '}': {
                        this.popGroup();
                        if (this.group.isEmpty()) {
                            capturing = 0;
                            nexts = null;
                            continue block15;
                        }
                        this.group.pop();
                        nexts = FormatReader.CONTINUE_OR_END;
                        continue block15;
                    }
                    case ']': {
                        if (capturing == 4 || capturing == 5) {
                            capturing = 0;
                            nexts = FormatReader.CONTINUE_OR_END;
                            this.putArrayValue();
                            this.putEntry(true);
                            continue block15;
                        }
                        throw new IllegalStateException("JSON array end detected but not capturing an array");
                    }
lbl101:
                    // 5 sources

                    default: {
                        switch (capturing) {
                            case 1: {
                                this.appendKey(c);
                                continue block15;
                            }
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: {
                                this.appendValue(c);
                                continue block15;
                            }
                            case 0: {
                                throw new IllegalStateException("Not capturing values");
                            }
                        }
                    }
                }
            }
        }

        @Override
        public String read(String fieldName) {
            Object value = this.values.get(Tools.concat("", (!this.group.isEmpty() ? "." : "") + fieldName, '.', this.group));
            if (value instanceof String) {
                String s = (String)value;
                return s;
            }
            return null;
        }

        @Override
        public String[] readArray(String fieldName) {
            Object value = this.values.get(Tools.concat("", (!this.group.isEmpty() ? "." : "") + fieldName, '.', this.group));
            if (value instanceof String[]) {
                String[] s = (String[])value;
                return s;
            }
            return null;
        }

        @Override
        public void push(String group) {
            this.group.push(group);
        }

        @Override
        public void pop() {
            this.group.pop();
        }

        @Override
        public void close() {
            this.values.clear();
            this.group.clear();
            this.key.setLength(0);
            this.value.setLength(0);
            this.arrayValues.clear();
        }

        private void appendKey(char c) {
            if (this.escaped) {
                this.key.append("\\");
            }
            this.key.append(c);
            this.escaped = false;
        }

        private void appendValue(char c) {
            if (this.escaped) {
                this.value.append("\\");
            }
            this.value.append(c);
            this.escaped = false;
        }

        private void putEntry(boolean array) {
            this.values.put(Tools.concat("", (!this.group.isEmpty() ? "." : "") + this.key, '.', this.group), array ? Arrays.toString(this.arrayValues.toArray()) : this.value.toString());
            this.clear();
            this.escaped = false;
        }

        private void putArrayValue() {
            this.arrayValues.add(this.value.toString());
            this.value.setLength(0);
            this.escaped = false;
        }

        private void putValue() {
            this.value.append(this.value.toString());
            this.value.setLength(0);
            this.escaped = false;
        }

        private void pushGroup() {
            this.group.push(this.key.toString());
            this.key.setLength(0);
        }

        private void popGroup() {
            if (this.group.isEmpty()) {
                this.finished = true;
                return;
            }
            this.group.pop();
        }

        private void clear() {
            this.key.setLength(0);
            this.value.setLength(0);
            this.arrayValues.clear();
        }
    }

    public static class FormatWriter
    implements IFormatWriter {
        private final Stack<String> group = new Stack();
        private final BufferedWriter writer;
        private final StringBuilder buffer = new StringBuilder();
        private boolean beginned = false;

        public FormatWriter(Path path) throws IOException {
            if (!path.toFile().getParentFile().exists() && !path.toFile().getParentFile().mkdirs()) {
                throw new IOException("Failed to create parent directories for " + path);
            }
            this.writer = new BufferedWriter(new FileWriter(path.toFile(), StandardCharsets.UTF_8));
            this.buffer.append('{');
            this.buffer.append("\n");
        }

        @Override
        public void write(String comment) {
        }

        @Override
        public void write(String fieldName, String value, Class<?> type, Class<?> subType) {
            if (this.beginned) {
                this.buffer.append(',');
                this.buffer.append("\n");
            } else {
                this.beginned = true;
            }
            System.out.println("Writing field: " + fieldName + " with value: " + value + " of type: " + type.getName() + " and subtype: " + (subType != null ? subType.getName() : "null"));
            boolean isString = !Number.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type);
            this.buffer.append("\t".repeat(this.group.size() + 1));
            this.buffer.append('\"');
            this.buffer.append(fieldName);
            this.buffer.append('\"');
            this.buffer.append(':');
            this.buffer.append(" ");
            if (isString) {
                this.buffer.append('\"');
            }
            this.buffer.append(value);
            if (isString) {
                this.buffer.append('\"');
            }
        }

        @Override
        public void write(String fieldName, String[] values, Class<?> type, Class<?> subType) {
            if (this.beginned) {
                this.buffer.append(',');
                this.buffer.append("\n");
            } else {
                this.beginned = true;
            }
            boolean isString = !subType.isAssignableFrom(Number.class) || !subType.isAssignableFrom(Boolean.class);
            this.buffer.append("\t".repeat(this.group.size() + 1));
            this.buffer.append('\"');
            this.buffer.append(fieldName);
            this.buffer.append('\"');
            this.buffer.append(':');
            this.buffer.append(" ");
            this.buffer.append('[');
            this.buffer.append("\n");
            Iterator<String> it = List.of(values).iterator();
            while (it.hasNext()) {
                String value = it.next();
                this.buffer.append("\t".repeat(this.group.size() + 2));
                if (isString) {
                    this.buffer.append('\"');
                }
                this.buffer.append(value);
                if (isString) {
                    this.buffer.append('\"');
                }
                if (it.hasNext()) {
                    this.buffer.append(',');
                }
                this.buffer.append("\n");
            }
            this.buffer.append("\t".repeat(this.group.size() + 1));
            this.buffer.append(']');
        }

        @Override
        public void push(String groupName) {
            if (this.beginned) {
                this.buffer.append(',');
                this.buffer.append("\n");
            } else {
                this.beginned = true;
            }
            this.buffer.append("\t".repeat(this.group.size() + 1));
            this.buffer.append('\"');
            this.buffer.append(groupName);
            this.buffer.append('\"');
            this.buffer.append(':');
            this.buffer.append(" ");
            this.buffer.append('{');
            this.buffer.append("\n");
            this.group.push(groupName);
            this.beginned = false;
        }

        @Override
        public void pop() {
            this.group.pop();
            this.buffer.append('\n');
            this.buffer.append("\t".repeat(this.group.size() + 1));
            this.buffer.append('}');
            this.buffer.append("\n");
        }

        @Override
        public void close() throws IOException {
            this.buffer.append('}');
            this.writer.write(this.buffer.toString());
            this.writer.flush();
            this.writer.close();
        }
    }
}

