/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia;

import java.io.File;
import java.nio.file.Path;
import java.util.Objects;
import java.util.ServiceLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.omegaconfig.OmegaConfig;
import org.watermedia.WaterMediaConfig;
import org.watermedia.api.WaterMediaAPI;
import org.watermedia.tools.IOTool;

public class WaterMedia {
    private static final Marker IT = MarkerManager.getMarker((String)WaterMedia.class.getSimpleName());
    public static final String ID = "watermedia";
    public static final String NAME = "WATERMeDIA";
    public static final String VERSION = IOTool.getVersion();
    public static final String USER_AGENT = "WaterMedia/" + VERSION;
    public static final Logger LOGGER = LogManager.getLogger((String)"watermedia");
    private static final Path DEFAULT_TEMP = new File(System.getProperty("java.io.tmpdir")).toPath().toAbsolutePath().resolve("watermedia");
    private static final Path DEFAULT_CWD = new File("run").toPath().toAbsolutePath();
    private static WaterMedia instance;
    private static ServiceLoader<WaterMediaAPI> apis;
    public final String name;
    public final Path tmp;
    public final Path cwd;
    public final boolean clientSide;

    private WaterMedia(String name, Path tmp, Path cwd, boolean clientSide) {
        if (instance != null) {
            throw new IllegalStateException("Instance was already created");
        }
        this.name = name;
        this.tmp = tmp == null ? DEFAULT_TEMP : tmp;
        this.cwd = cwd == null ? DEFAULT_CWD : cwd;
        this.clientSide = clientSide;
    }

    public static synchronized void start(String name, Path tmp, Path cwd, boolean clientSide) {
        Objects.requireNonNull(name, "Name of the environment cannot be null");
        instance = new WaterMedia(name, tmp, cwd, clientSide);
        LOGGER.info(IT, "Preparing '{}v{}' for '{}'", (Object)NAME, (Object)VERSION, (Object)name);
        LOGGER.info(IT, "OS Detected: {} ({})", (Object)System.getProperty("os.name"), (Object)System.getProperty("os.arch"));
        LOGGER.info(IT, "Registering {} config spec into OmegaConfig", (Object)NAME);
        OmegaConfig.register(WaterMediaConfig.class);
        LOGGER.info(IT, "Successfully registered config spec");
        apis = ServiceLoader.load(WaterMediaAPI.class);
        for (WaterMediaAPI api : apis) {
            LOGGER.info(IT, "Loading {}", (Object)api.name());
            try {
                if (!api.start(instance)) {
                    LOGGER.warn(IT, "The {} module refuses to load", (Object)api.name());
                }
            }
            catch (Exception e) {
                LOGGER.fatal(IT, "Unexpected exception handled loading API module {}, we cannot recover back!", (Object)api.name());
                throw new UnsupportedOperationException("Failed to start WATERMeDIA: Multimedia API", e);
            }
            LOGGER.info(IT, "Loaded {} successfully", (Object)api.name());
        }
    }

    public static String toId(String path) {
        return "watermedia:" + path;
    }

    public static void checkIsClientSideOrThrow(Class<?> clazz) {
        if (instance == null) {
            throw new IllegalStateException("WATERMeDIA was not initialized");
        }
        if (!WaterMedia.instance.clientSide) {
            throw new IllegalStateException("Called a " + clazz.getSimpleName() + " method on a server-side environment");
        }
    }
}

