/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.decode.formats.gif.packets;

import java.nio.ByteBuffer;

public record ScreenDescriptor(int width, int height, boolean globalColorTableFlag, int colorResolution, boolean sortFlag, int globalColorTableSize, int backgroundColorIndex, int pixelAspectRatio) {
    public static final int SIGNATURE_SIZE = 7;

    public ScreenDescriptor {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Width and height must be positive integers");
        }
        if (globalColorTableSize < 0 || globalColorTableSize > 7) {
            throw new IllegalArgumentException("Global color table size must be between 0 and 7");
        }
        if (colorResolution < 1 || colorResolution > 8) {
            throw new IllegalArgumentException("Color resolution must be between 1 and 8");
        }
        if (pixelAspectRatio < 0 || pixelAspectRatio > 255) {
            throw new IllegalArgumentException("Pixel aspect ratio must be between 0 and 255");
        }
    }

    public static ScreenDescriptor read(ByteBuffer buffer) {
        if (buffer.remaining() < 7) {
            throw new IllegalArgumentException("Buffer does not contain enough data for Screen Descriptor");
        }
        int width = Short.toUnsignedInt(buffer.getShort());
        int height = Short.toUnsignedInt(buffer.getShort());
        int packedFields = Byte.toUnsignedInt(buffer.get());
        boolean globalColorTableFlag = (packedFields & 0x80) != 0;
        int colorResolution = ((packedFields & 0x70) >> 4) + 1;
        boolean sortFlag = (packedFields & 8) != 0;
        int globalColorTableSize = packedFields & 7;
        int backgroundColorIndex = Byte.toUnsignedInt(buffer.get());
        int pixelAspectRatio = Byte.toUnsignedInt(buffer.get());
        return new ScreenDescriptor(width, height, globalColorTableFlag, colorResolution, sortFlag, globalColorTableSize, backgroundColorIndex, pixelAspectRatio);
    }
}

