/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.decode.formats.png;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.watermedia.api.decode.Decoder;
import org.watermedia.api.decode.Image;
import org.watermedia.api.decode.formats.png.chunks.ACTL;
import org.watermedia.api.decode.formats.png.chunks.FCTL;

public class PNG
extends Decoder {
    static final int IHDR_SIG = 1229472850;
    static final int IEND_SIG = 1229278788;
    static final byte[] PNGF_SIG = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};

    @Override
    public boolean supported(ByteBuffer buffer) {
        buffer.mark();
        for (byte value : PNGF_SIG) {
            if (buffer.get() == value) continue;
            buffer.reset();
            return false;
        }
        return true;
    }

    @Override
    public Image decode(ByteBuffer buffer) throws IOException {
        ACTL actl = ACTL.read(buffer);
        HashSet images = new HashSet();
        for (int i = 0; i < actl.frameCount(); ++i) {
            FCTL frameData = FCTL.read(buffer);
            int chunkSize = buffer.getInt();
            int sig = buffer.getInt();
            ByteBuffer pngData = buffer.duplicate();
            pngData.limit(buffer.position() + (chunkSize - 4));
            buffer.position(buffer.position() + chunkSize);
            ByteBuffer pixels = ByteBuffer.allocate(frameData.width() * frameData.height());
            block4: while (pngData.hasRemaining()) {
                byte filter = pngData.get();
                switch (filter) {
                    case 0: {
                        pngData.limit(pngData.position() + frameData.width());
                        pixels.put(pngData);
                        pngData.limit(pngData.capacity());
                        continue block4;
                    }
                }
                throw new IOException("Pixels uses (" + filter + ") an unsupported");
            }
        }
        return null;
    }

    @Override
    public boolean test() {
        return false;
    }

    private ByteBuffer inflate(ByteBuffer buffer) {
        Inflater inflate = new Inflater();
        inflate.setInput(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] data = new byte[8192];
        while (!inflate.finished()) {
            try {
                int length = inflate.inflate(data);
                output.write(data, 0, length);
            }
            catch (DataFormatException e) {
                throw new RuntimeException(e);
            }
        }
        inflate.end();
        return ByteBuffer.wrap(data);
    }
}

