/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.decode.formats.png.chunks;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.watermedia.api.decode.formats.png.chunks.CHUNK;
import org.watermedia.tools.DataTool;

public record ACTL(int frameCount, int loopCount) {
    public static final int SIGNATURE = 1633899596;

    public static ACTL read(ByteBuffer buffer) {
        int length = buffer.getInt();
        int type = buffer.getInt();
        if (type != 1633899596) {
            throw new IllegalArgumentException("Invalid chunk type for ACTL: " + Integer.toHexString(type));
        }
        int frameCount = buffer.getInt();
        int loopCount = buffer.getInt();
        return new ACTL(frameCount, loopCount);
    }

    public static ACTL convert(CHUNK chunk, ByteOrder order) {
        if (chunk.type() != 1633899596) {
            throw new IllegalArgumentException("Invalid chunk type for ACTL: " + Integer.toHexString(chunk.type()));
        }
        byte[] data = chunk.data();
        int frameCount = DataTool.toInt(data[0], data[1], data[2], data[3], order);
        int loopCount = DataTool.toInt(data[4], data[5], data[6], data[7], order);
        return new ACTL(frameCount, loopCount);
    }
}

