/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.decode.formats.webp;

import java.nio.ByteBuffer;
import java.util.function.Supplier;

public abstract class WebPCodec {
    public abstract void initialize();

    protected abstract FrameBuffer decodeVP8(ByteBuffer var1, VP8FrameHeader var2);

    protected abstract FrameBuffer decodeVP8L(ByteBuffer var1);

    protected abstract VP8FrameHeader parseVP8Header(ByteBuffer var1);

    protected abstract VP8LDecoder parseVP8LHeader(ByteBuffer var1);

    protected abstract byte[] decodeAlpha(ByteBuffer var1, int var2, int var3, int var4, int var5, int var6);

    protected abstract void applyAlphaFilter(byte[] var1, int var2, int var3, int var4);

    protected abstract void reconstructMacroBlocks(FrameBuffer var1, BitstreamReader var2);

    protected abstract void decodeEntropyCoded(VP8LDecoder var1, BitstreamReader var2);

    protected abstract void applyColorTransform(int[] var1, int var2, int var3);

    protected abstract void applyPredictorTransform(int[] var1, int var2, int var3);

    protected abstract void applyCrossColorTransform(int[] var1, int var2, int var3);

    protected abstract void applySubtractGreenTransform(int[] var1, int var2, int var3);

    protected abstract void applyColorIndexingTransform(int[] var1, int var2, int var3);

    protected abstract ByteBuffer blendFrames(ByteBuffer var1, AnimationFrame var2, int var3, int var4);

    protected abstract void disposeFrame(ByteBuffer var1, AnimationFrame var2, int var3, int var4, int var5);

    protected abstract ByteBuffer convertYUVToBGRA(FrameBuffer var1);

    protected abstract void parseHuffmanCodes(BitstreamReader var1, VP8LDecoder var2);

    protected abstract void decompressHuffman(BitstreamReader var1, int[] var2, int var3);

    protected abstract void parseColorCache(BitstreamReader var1, VP8LDecoder var2);

    public abstract void cleanup();

    protected static class BitstreamReader {
        protected ByteBuffer buffer;
        protected int bitsInBuffer;
        protected long value;
        protected int pos;

        public BitstreamReader(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        public int readBits(int numBits) {
            return 0;
        }

        public boolean readBool() {
            return false;
        }

        public int readLiteral(int numBits) {
            return 0;
        }

        public void fillBitWindow() {
        }
    }

    public static class AnimationFrame {
        public int x;
        public int y;
        public int width;
        public int height;
        public long duration;
        public int disposeMethod;
        public int blendMethod;
        public ByteBuffer frameData;
        public ByteBuffer alphaData;
    }

    public static class VP8LDecoder {
        public int width;
        public int height;
        public int xsize;
        public int ysize;
        public boolean hasAlpha;
        public int[] pixels;
    }

    public static class VP8FrameHeader {
        public boolean keyFrame;
        public int version;
        public boolean showFrame;
        public int partitionLength;
        public int width;
        public int height;
        public int horizontalScale;
        public int verticalScale;
    }

    public static class FrameBuffer {
        public byte[] yPlane;
        public byte[] uPlane;
        public byte[] vPlane;
        public byte[] alphaPlane;
        public int yStride;
        public int uvStride;
        public int alphaStride;
        public int width;
        public int height;
        public boolean hasAlpha;
        public Supplier<ByteBuffer> toBGRA;
    }
}

