/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.math;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum MathAPI {
    EASE_IN{

        @Override
        public double apply(double start, double end, double value) {
            return MathAPI.easeIn(start, end, value);
        }
    }
    ,
    EASE_OUT{

        @Override
        public double apply(double start, double end, double value) {
            return MathAPI.easeOut(start, end, value);
        }
    }
    ,
    EASE_IN_OUT{

        @Override
        public double apply(double start, double end, double value) {
            return MathAPI.easeInOut(start, end, value);
        }
    }
    ,
    EASE_OUT_IN{

        @Override
        public double apply(double start, double end, double value) {
            return MathAPI.easeOutIn(start, end, value);
        }
    }
    ,
    EASE_IN_SINE{

        @Override
        public double apply(double start, double end, double value) {
            return MathAPI.easeInSine(start, end, value);
        }
    }
    ,
    EASE_OUT_SINE{

        @Override
        public double apply(double start, double end, double value) {
            return MathAPI.easeOutSine(start, end, value);
        }
    }
    ,
    EASE_IN_OUT_SINE{

        @Override
        public double apply(double start, double end, double value) {
            return MathAPI.easeInOutSine(start, end, value);
        }
    }
    ,
    EASE_IN_CUBIC{

        @Override
        public double apply(double start, double end, double value) {
            return MathAPI.easeInCubic(start, end, value);
        }
    }
    ,
    EASE_OUT_CUBIC{

        @Override
        public double apply(double start, double end, double value) {
            return MathAPI.easeOutCubic(start, end, value);
        }
    }
    ,
    EASE_IN_OUT_CUBIC{

        @Override
        public double apply(double start, double end, double value) {
            return MathAPI.easeInOutCubic(start, end, value);
        }
    }
    ,
    EASE_IN_QUAD{

        @Override
        public double apply(double start, double end, double value) {
            return MathAPI.easeInQuad(start, end, value);
        }
    }
    ,
    EASE_OUT_QUAD{

        @Override
        public double apply(double start, double end, double value) {
            return MathAPI.easeOutQuad(start, end, value);
        }
    }
    ,
    EASE_IN_OUT_QUAD{

        @Override
        public double apply(double start, double end, double value) {
            return MathAPI.easeInOutQuad(start, end, value);
        }
    }
    ,
    EASE_IN_ELASTIC{

        @Override
        public double apply(double start, double end, double value) {
            return MathAPI.easeInElastic(start, end, value);
        }
    }
    ,
    EASE_OUT_ELASTIC{

        @Override
        public double apply(double start, double end, double value) {
            return MathAPI.easeOutElastic(start, end, value);
        }
    }
    ,
    EASE_IN_OUT_ELASTIC{

        @Override
        public double apply(double start, double end, double value) {
            return MathAPI.easeInOutElastic(start, end, value);
        }
    }
    ,
    EASE_IN_QUINT{

        @Override
        public double apply(double start, double end, double value) {
            return MathAPI.easeInQuint(start, end, value);
        }
    }
    ,
    EASE_OUT_QUINT{

        @Override
        public double apply(double start, double end, double value) {
            return MathAPI.easeOutQuint(start, end, value);
        }
    }
    ,
    EASE_IN_OUT_QUINT{

        @Override
        public double apply(double start, double end, double value) {
            return MathAPI.easeInOutQuint(start, end, value);
        }
    }
    ,
    EASE_IN_CIRCLE{

        @Override
        public double apply(double start, double end, double value) {
            return MathAPI.easeInCircle(start, end, value);
        }
    }
    ,
    EASE_OUT_CIRCLE{

        @Override
        public double apply(double start, double end, double value) {
            return MathAPI.easeOutCircle(start, end, value);
        }
    }
    ,
    EASE_IN_OUT_CIRCLE{

        @Override
        public double apply(double start, double end, double value) {
            return MathAPI.easeInOutCircle(start, end, value);
        }
    }
    ,
    EASE_IN_EXPO{

        @Override
        public double apply(double start, double end, double value) {
            return MathAPI.easeInExpo(start, end, value);
        }
    }
    ,
    EASE_OUT_EXPO{

        @Override
        public double apply(double start, double end, double value) {
            return MathAPI.easeOutExpo(start, end, value);
        }
    }
    ,
    EASE_IN_OUT_EXPO{

        @Override
        public double apply(double start, double end, double value) {
            return MathAPI.easeInOutExpo(start, end, value);
        }
    }
    ,
    EASE_IN_BACK{

        @Override
        public double apply(double start, double end, double value) {
            return MathAPI.easeInBack(start, end, value);
        }
    }
    ,
    EASE_OUT_BACK{

        @Override
        public double apply(double start, double end, double value) {
            return MathAPI.easeOutBack(start, end, value);
        }
    }
    ,
    EASE_IN_OUT_BACK{

        @Override
        public double apply(double start, double end, double value) {
            return MathAPI.easeInOutBack(start, end, value);
        }
    }
    ,
    EASE_IN_BOUNCE{

        @Override
        public double apply(double start, double end, double value) {
            return MathAPI.easeInBounce(start, end, value);
        }
    }
    ,
    EASE_OUT_BOUNCE{

        @Override
        public double apply(double start, double end, double value) {
            return MathAPI.easeOutBounce(start, end, value);
        }
    }
    ,
    EASE_IN_OUT_BOUNCE{

        @Override
        public double apply(double start, double end, double value) {
            return MathAPI.easeInOutBounce(start, end, value);
        }
    };

    private static final int SIN_SIZE = 65536;
    private static final float[] SIN;

    public abstract double apply(double var1, double var3, double var5);

    public static long tickToMs(int ticks) {
        return (long)ticks * 50L;
    }

    public static long tickToMs(float partialTicks) {
        return (long)(partialTicks * 50.0f);
    }

    public static int msToTick(long ms) {
        return (int)(ms / 50L);
    }

    public static double scaleTempo(long start, long end, long time) {
        if (start < 0L || end < 0L || time < 0L) {
            throw new IllegalArgumentException("Invalid negative value");
        }
        long duration = end - start;
        long realTime = time - start;
        if (realTime == 0L || duration == 0L) {
            return 0.0;
        }
        long result = realTime / duration;
        if (realTime > duration) {
            result %= duration;
        }
        return result;
    }

    public static double scaleTempo(double start, double end, double time) {
        if (start < 0.0 || end < 0.0 || time < 0.0) {
            throw new IllegalArgumentException("Invalid negative value");
        }
        double duration = end - start;
        double realTime = time - start;
        if (realTime == 0.0 || duration == 0.0) {
            return 0.0;
        }
        double result = realTime / duration;
        if (realTime > duration) {
            result %= duration;
        }
        return result;
    }

    public static double scaleTempoTick(int startTick, int endTick, int timeTick) {
        return MathAPI.scaleTempo(MathAPI.tickToMs(startTick), MathAPI.tickToMs(endTick), MathAPI.tickToMs(timeTick));
    }

    public static double scaleDesTempo(long start, long end, long time) {
        if (start < 0L || end < 0L || time < 0L) {
            throw new IllegalArgumentException("Invalid negative value");
        }
        long duration = end - start;
        long realTime = time - start;
        if (realTime == 0L || duration == 0L) {
            return 0.0;
        }
        return (double)realTime / (double)duration;
    }

    public static double scaleDesTempo(double start, double end, double time) {
        if (start < 0.0 || end < 0.0 || time < 0.0) {
            throw new IllegalArgumentException("Invalid negative value");
        }
        double duration = end - start;
        double realTime = time - start;
        if (realTime == 0.0 || duration == 0.0) {
            return 0.0;
        }
        double result = realTime / duration;
        return Double.isNaN(result) ? 0.0 : result;
    }

    public static double scaleDesTempoTick(int startTick, int endTick, int timeTick) {
        return MathAPI.scaleTempo(MathAPI.tickToMs(startTick), MathAPI.tickToMs(endTick), MathAPI.tickToMs(timeTick));
    }

    public static long floorMod(long x, long y) {
        if (x == 0L || y == 0L) {
            return 0L;
        }
        long r = x % y;
        if ((x ^ y) < 0L && r != 0L) {
            return r + y;
        }
        return r;
    }

    public static int floorMod(int x, int y) {
        if (x == 0 || y == 0) {
            return 0;
        }
        int r = x % y;
        if ((x ^ y) < 0 && r != 0) {
            return r + y;
        }
        return r;
    }

    public static int floorMod(long x, int y) {
        return (int)MathAPI.floorMod(x, (long)y);
    }

    public static int floorMod(int x, long y) {
        return (int)MathAPI.floorMod((long)x, y);
    }

    public static short min(short a, short b) {
        return a <= b ? a : b;
    }

    public static byte min(byte a, byte b) {
        return a <= b ? a : b;
    }

    public static int argb(int a, int r, int g, int b) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static double easeIn(double start, double end, double t) {
        return start + (end - start) * t * t;
    }

    public static double easeOut(double start, double end, double t) {
        return start + (end - start) * (1.0 - Math.pow(1.0 - t, 2.0));
    }

    public static double easeInOut(double start, double end, double t) {
        return t < 0.5 ? MathAPI.easeIn(start, end / 2.0, t * 2.0) : MathAPI.easeOut(start + end / 2.0, end, (t - 0.5) * 2.0);
    }

    public static double easeOutIn(double start, double end, double t) {
        return t < 0.5 ? MathAPI.easeOut(start, end / 2.0, t * 2.0) : MathAPI.easeIn(start + end / 2.0, end, (t - 0.5) * 2.0);
    }

    public static double easeInCircle(double start, double end, double t) {
        return start + (end - start) * (1.0 - Math.sqrt(1.0 - t * t));
    }

    public static double easyEase(double start, double end, double t) {
        return start + (end - start) * (t < 0.5 ? 2.0 * t * t : -1.0 + 2.0 * t * (2.0 - t));
    }

    public static double easeInSine(double start, double end, double t) {
        return (end - start) * (double)(1.0f - MathAPI.cos((float)(t * Math.PI / 2.0))) + start;
    }

    public static double easeInCubic(double start, double end, double t) {
        return (end - start) * (t * t * t) + start;
    }

    public static double easeInQuint(double start, double end, double t) {
        return (end - start) * (t * t * t * t * t) + start;
    }

    public static double easeInElastic(double start, double end, double t) {
        if (t == 0.0) {
            return start;
        }
        if (t == 1.0) {
            return end;
        }
        double c4 = 2.0943951023931953;
        return start - Math.pow(2.0, 10.0 * t - 10.0) * (double)MathAPI.sin((float)((t * 10.0 - 10.75) * 2.0943951023931953)) * (end - start);
    }

    public static double easeOutSine(double start, double end, double t) {
        return (end - start) * (double)MathAPI.sin((float)(t * Math.PI / 2.0)) + start;
    }

    public static double easeOutCubic(double start, double end, double t) {
        return (end - start) * (1.0 - Math.pow(1.0 - t, 3.0)) + start;
    }

    public static double easeOutQuint(double start, double end, double t) {
        return (end - start) * (1.0 - Math.pow(1.0 - t, 5.0)) + start;
    }

    public static double easeOutCircle(double start, double end, double t) {
        return (end - start) * Math.sqrt(1.0 - Math.pow(t - 1.0, 2.0)) + start;
    }

    public static double easeOutElastic(double start, double end, double t) {
        if (t == 0.0) {
            return start;
        }
        if (t == 1.0) {
            return end;
        }
        return (end - start) * (Math.pow(2.0, -10.0 * t) * (double)MathAPI.sin((float)((t * 10.0 - 0.75) * 2.0943951023931953)) + 1.0) + start;
    }

    public static double easeInOutSine(double start, double end, double t) {
        return (end - start) * (double)(-(MathAPI.cos((float)(Math.PI * t)) - 1.0f) / 2.0f) + start;
    }

    public static double easeInOutCubic(double start, double end, double t) {
        if (t < 0.5) {
            return (end - start) * (4.0 * t * t * t) + start;
        }
        return (end - start) * (1.0 - Math.pow(-2.0 * t + 2.0, 3.0) / 2.0) + start;
    }

    public static double easeInOutQuint(double start, double end, double t) {
        if (t < 0.5) {
            return (end - start) * (16.0 * Math.pow(t, 5.0)) + start;
        }
        return (end - start) * (1.0 - Math.pow(-2.0 * t + 2.0, 5.0) / 2.0) + start;
    }

    public static double easeInOutCircle(double start, double end, double t) {
        if (t < 0.5) {
            return start + (end - start) * (1.0 - Math.sqrt(1.0 - Math.pow(2.0 * t, 2.0))) / 2.0;
        }
        return start + (end - start) * (Math.sqrt(1.0 - Math.pow(-2.0 * t + 2.0, 2.0)) + 1.0) / 2.0;
    }

    public static double easeInOutElastic(double start, double end, double t) {
        if (t == 0.0) {
            return start;
        }
        if (t == 1.0) {
            return end;
        }
        double c5 = 1.3962634015954636;
        if (t < 0.5) {
            return start - Math.pow(2.0, 20.0 * t - 10.0) * (double)MathAPI.sin((float)((20.0 * t - 11.125) * 1.3962634015954636)) / 2.0;
        }
        return start + Math.pow(2.0, -20.0 * t + 10.0) * (double)MathAPI.sin((float)((20.0 * t - 11.125) * 1.3962634015954636)) / 2.0 + (end - start);
    }

    public static double easeInQuad(double start, double end, double t) {
        return (end - start) * (t * t) + start;
    }

    public static double easeInQuart(double start, double end, double t) {
        return (end - start) * (t * t * t * t) + start;
    }

    public static double easeInExpo(double start, double end, double t) {
        if (t == 0.0) {
            return start;
        }
        return (end - start) * Math.pow(2.0, 10.0 * t - 10.0) + start;
    }

    public static double easeInBack(double start, double end, double t) {
        double c1 = 1.70158;
        double c3 = 2.70158;
        return (end - start) * (2.70158 * t * t * t - 1.70158 * t * t) + start;
    }

    public static double easeInBounce(double start, double end, double t) {
        return start + (end - start) * (1.0 - MathAPI.easeOutBounce(0.0, 1.0, 1.0 - t));
    }

    public static double easeOutBounce(double start, double end, double t) {
        double n1 = 7.5625;
        double d1 = 2.75;
        double value = t < 0.36363636363636365 ? 7.5625 * t * t : (t < 0.7272727272727273 ? 7.5625 * (t -= 0.5454545454545454) * t + 0.75 : (t < 0.9090909090909091 ? 7.5625 * (t -= 0.8181818181818182) * t + 0.9375 : 7.5625 * (t -= 0.9545454545454546) * t + 0.984375));
        return start + (end - start) * value;
    }

    public static double easeOutQuad(double start, double end, double t) {
        return start + (end - start) * (1.0 - Math.pow(1.0 - t, 2.0));
    }

    public static double easeOutQuart(double start, double end, double t) {
        return start + (end - start) * (1.0 - Math.pow(1.0 - t, 4.0));
    }

    public static double easeOutExpo(double start, double end, double t) {
        if (t == 1.0) {
            return end;
        }
        return start + (end - start) * (1.0 - Math.pow(2.0, -10.0 * t));
    }

    public static double easeOutBack(double start, double end, double t) {
        double c1 = 1.70158;
        double c3 = 2.70158;
        double adjustedT = t - 1.0;
        return start + (end - start) * (1.0 + 2.70158 * Math.pow(adjustedT, 3.0) + 1.70158 * Math.pow(adjustedT, 2.0));
    }

    public static double easeInOutQuad(double start, double end, double t) {
        if (t < 0.5) {
            return start + (end - start) * (2.0 * t * t);
        }
        return start + (end - start) * (1.0 - Math.pow(-2.0 * t + 2.0, 2.0) / 2.0);
    }

    public static double easeInOutQuart(double start, double end, double t) {
        if (t < 0.5) {
            return start + (end - start) * (8.0 * Math.pow(t, 4.0));
        }
        return start + (end - start) * (1.0 - Math.pow(-2.0 * t + 2.0, 4.0) / 2.0);
    }

    public static double easeInOutExpo(double start, double end, double t) {
        if (t == 0.0) {
            return start;
        }
        if (t == 1.0) {
            return end;
        }
        if (t < 0.5) {
            return start + (end - start) * (Math.pow(2.0, 20.0 * t - 10.0) / 2.0);
        }
        return start + (end - start) * ((2.0 - Math.pow(2.0, -20.0 * t + 10.0)) / 2.0);
    }

    public static double easeInOutBack(double start, double end, double t) {
        double c1 = 1.70158;
        double c2 = 2.5949095;
        if (t < 0.5) {
            return start + Math.pow(2.0 * t, 2.0) * (7.189819 * t - 2.5949095) / 2.0 * (end - start);
        }
        return start + (Math.pow(2.0 * t - 2.0, 2.0) * (3.5949095 * (2.0 * t - 2.0) + 2.5949095) + 2.0) / 2.0 * (end - start);
    }

    public static double easeInOutBounce(double start, double end, double t) {
        if (t < 0.5) {
            return start + (end - start) * (1.0 - MathAPI.easeOutBounce(0.0, 1.0, 1.0 - 2.0 * t)) / 2.0;
        }
        return start + (end - start) * (1.0 + MathAPI.easeOutBounce(0.0, 1.0, 2.0 * t - 1.0)) / 2.0;
    }

    public static int clamp(int min, int max, int value) {
        return value >= max ? max : (value <= min ? min : value);
    }

    public static float sin(float pValue) {
        return SIN[(int)(pValue * 10430.378f) & 0xFFFF];
    }

    public static float cos(float pValue) {
        return SIN[(int)(pValue * 10430.378f + 16384.0f) & 0xFFFF];
    }

    public static int sumArray(int[] arr) {
        int r = 0;
        for (int i : arr) {
            r += i;
        }
        return r;
    }

    public static long sumArray(long[] arr) {
        long r = 0L;
        for (long i : arr) {
            r += i;
        }
        return r;
    }

    static {
        SIN = new float[65536];
        for (int i = 0; i < 65536; ++i) {
            MathAPI.SIN[i] = (float)Math.sin((double)i * Math.PI * 2.0 / 65536.0);
        }
    }
}

