/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.media;

import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.bytedeco.ffmpeg.avcodec.AVCodec;
import org.bytedeco.ffmpeg.avcodec.AVCodecContext;
import org.bytedeco.ffmpeg.avcodec.AVCodecParameters;
import org.bytedeco.ffmpeg.avcodec.AVPacket;
import org.bytedeco.ffmpeg.avformat.AVFormatContext;
import org.bytedeco.ffmpeg.avformat.AVStream;
import org.bytedeco.ffmpeg.avutil.AVChannelLayout;
import org.bytedeco.ffmpeg.avutil.AVFrame;
import org.bytedeco.ffmpeg.avutil.AVRational;
import org.bytedeco.ffmpeg.global.avcodec;
import org.bytedeco.ffmpeg.global.avformat;
import org.bytedeco.ffmpeg.global.avutil;
import org.bytedeco.ffmpeg.global.swresample;
import org.bytedeco.ffmpeg.global.swscale;
import org.bytedeco.ffmpeg.swresample.SwrContext;
import org.bytedeco.ffmpeg.swscale.SwsContext;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.watermedia.WaterMedia;
import org.watermedia.api.media.MediaPlayer;

public final class FFMediaPlayer
extends MediaPlayer {
    private static final Marker IT = MarkerManager.getMarker((String)FFMediaPlayer.class.getSimpleName());
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = new ThreadFactory(){
        private int counter = 0;

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "FFMediaPlayer-Thread-" + this.counter++);
            t.setPriority(7);
            t.setDaemon(true);
            return t;
        }
    };
    private static final int AUDIO_SAMPLE_RATE = 44100;
    private static final int AUDIO_CHANNELS = 2;
    private static final int AUDIO_SAMPLES = 1024;
    private AVFormatContext formatContext;
    private AVCodecContext videoCodecContext;
    private AVCodecContext audioCodecContext;
    private SwsContext swsContext;
    private SwrContext swrContext;
    private int videoStreamIndex = -1;
    private int audioStreamIndex = -1;
    private Thread playerThread;
    private volatile boolean running = false;
    private volatile MediaPlayer.Status currentStatus = MediaPlayer.Status.WAITING;
    private volatile boolean pauseRequested = false;
    private volatile boolean stopRequested = false;
    private volatile long seekTarget = -1L;
    private volatile float speedFactor = 1.0f;
    private volatile double masterClock = 0.0;
    private volatile long clockBaseTime = -1L;
    private volatile boolean clockPaused = false;
    private volatile long pausedTime = 0L;
    private AVPacket packet;
    private AVFrame videoFrame;
    private AVFrame audioFrame;
    private AVFrame scaledFrame;
    private AVFrame resampledFrame;
    private ByteBuffer videoBuffer;
    private double videoTimeBase;
    private double audioTimeBase;

    public FFMediaPlayer(URI mrl, Thread renderThread, Executor renderThreadEx, boolean video, boolean audio) {
        super(mrl, renderThread, renderThreadEx, video, audio);
    }

    @Override
    public void start() {
        if (this.running) {
            this.stop();
        }
        this.playerThread = DEFAULT_THREAD_FACTORY.newThread(this::playerLoop);
        this.playerThread.setDaemon(true);
        this.playerThread.start();
    }

    @Override
    public void startPaused() {
        this.pauseRequested = true;
        this.start();
    }

    @Override
    public void release() {
        this.stop();
        super.release();
    }

    @Override
    public boolean pause() {
        return this.pause(true);
    }

    @Override
    public boolean pause(boolean paused) {
        if (paused && !this.pauseRequested) {
            this.pauseRequested = true;
            this.clockPaused = true;
            this.pausedTime = this.time();
            return true;
        }
        if (!paused && this.pauseRequested) {
            return this.resume();
        }
        return false;
    }

    @Override
    public boolean resume() {
        if (!this.pauseRequested) {
            return false;
        }
        this.pauseRequested = false;
        this.clockPaused = false;
        this.masterClock = FFMediaPlayer.secondsFromMs(this.pausedTime);
        this.clockBaseTime = System.nanoTime();
        return true;
    }

    @Override
    public boolean stop() {
        this.stopRequested = true;
        return true;
    }

    @Override
    public boolean togglePlay() {
        return this.pause(!this.pauseRequested);
    }

    @Override
    public boolean seek(long timeMs) {
        if (!this.canSeek()) {
            return false;
        }
        this.seekTarget = timeMs = Math.max(0L, Math.min(timeMs, this.duration()));
        return true;
    }

    @Override
    public boolean seekQuick(long timeMs) {
        return this.seek(timeMs);
    }

    @Override
    public boolean skipTime(long timeMs) {
        return this.seek(this.time() + timeMs);
    }

    @Override
    public boolean previousFrame() {
        AVStream videoStream;
        AVRational frameRate;
        if (!this.canSeek()) {
            return false;
        }
        long frameTimeMs = 33L;
        if (this.videoStreamIndex >= 0 && this.formatContext != null && (frameRate = (videoStream = this.formatContext.streams(this.videoStreamIndex)).avg_frame_rate()).num() > 0 && frameRate.den() > 0) {
            frameTimeMs = (long)(1000.0 * (double)frameRate.den() / (double)frameRate.num());
        }
        return this.seek(Math.max(0L, this.time() - frameTimeMs));
    }

    @Override
    public boolean nextFrame() {
        AVStream videoStream;
        AVRational frameRate;
        if (!this.canSeek()) {
            return false;
        }
        long frameTimeMs = 33L;
        if (this.videoStreamIndex >= 0 && this.formatContext != null && (frameRate = (videoStream = this.formatContext.streams(this.videoStreamIndex)).avg_frame_rate()).num() > 0 && frameRate.den() > 0) {
            frameTimeMs = (long)(1000.0 * (double)frameRate.den() / (double)frameRate.num());
        }
        return this.seek(this.time() + frameTimeMs);
    }

    @Override
    public boolean foward() {
        return this.skipTime(5000L);
    }

    @Override
    public boolean rewind() {
        return this.skipTime(-5000L);
    }

    @Override
    public float speed() {
        return this.speedFactor;
    }

    @Override
    public boolean speed(float speed) {
        if (speed <= 0.0f || speed > 4.0f) {
            return false;
        }
        this.speedFactor = speed;
        return true;
    }

    @Override
    public MediaPlayer.Status status() {
        return this.currentStatus;
    }

    @Override
    public boolean validSource() {
        return this.formatContext != null && (this.videoStreamIndex >= 0 || this.audioStreamIndex >= 0);
    }

    @Override
    public boolean liveSource() {
        return this.formatContext != null && this.formatContext.duration() == avutil.AV_NOPTS_VALUE;
    }

    @Override
    public boolean canSeek() {
        return this.validSource() && !this.liveSource();
    }

    @Override
    public boolean canPause() {
        return this.validSource();
    }

    @Override
    public boolean canPlay() {
        return this.validSource();
    }

    @Override
    public long duration() {
        return this.formatContext == null || this.liveSource() ? -1L : this.formatContext.duration() / 1000L;
    }

    @Override
    public long time() {
        if (this.clockPaused) {
            return FFMediaPlayer.msFromSeconds(this.masterClock);
        }
        if (this.clockBaseTime <= 0L) {
            return FFMediaPlayer.msFromSeconds(this.masterClock);
        }
        double elapsed = (double)(System.nanoTime() - this.clockBaseTime) / 1.0E9;
        return FFMediaPlayer.msFromSeconds(this.masterClock + elapsed * (double)this.speedFactor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void playerLoop() {
        try {
            while (this.running) {
                Thread.sleep(100L);
            }
            this.running = true;
            this.currentStatus = MediaPlayer.Status.LOADING;
            if (!this.init()) {
                this.currentStatus = MediaPlayer.Status.ERROR;
                return;
            }
            if (this.pauseRequested) {
                this.currentStatus = MediaPlayer.Status.PAUSED;
            } else {
                this.currentStatus = MediaPlayer.Status.PLAYING;
                this.clockBaseTime = System.nanoTime();
            }
            while (this.running && !this.stopRequested) {
                if (this.seekTarget >= 0L) {
                    long targetMs = this.seekTarget;
                    this.seekTarget = -1L;
                    if (this.formatContext != null && this.canSeek()) {
                        int result;
                        long currentMs = FFMediaPlayer.msFromSeconds(this.masterClock);
                        WaterMedia.LOGGER.info(IT, "Seeking to {}ms - current time {}ms", (Object)targetMs, (Object)currentMs);
                        if (this.videoCodecContext != null) {
                            avcodec.avcodec_flush_buffers(this.videoCodecContext);
                        }
                        if (this.audioCodecContext != null) {
                            avcodec.avcodec_flush_buffers(this.audioCodecContext);
                        }
                        long ffmpegTimestamp = targetMs / 1000L * 1000000L;
                        int seekFlags = 0;
                        if (targetMs < currentMs) {
                            seekFlags = 1;
                        }
                        if ((result = avformat.av_seek_frame(this.formatContext, -1, ffmpegTimestamp, seekFlags)) >= 0) {
                            this.masterClock = FFMediaPlayer.secondsFromMs(targetMs);
                            this.clockBaseTime = System.nanoTime();
                            WaterMedia.LOGGER.info(IT, "Seek completed to {}ms", (Object)targetMs);
                            continue;
                        }
                        WaterMedia.LOGGER.error(IT, "av_seek_frame failed with error: {}", (Object)result);
                    } else {
                        WaterMedia.LOGGER.warn(IT, "Cannot seek - invalid format context or live stream");
                    }
                }
                if (this.pauseRequested && this.currentStatus != MediaPlayer.Status.PAUSED) {
                    this.currentStatus = MediaPlayer.Status.PAUSED;
                } else if (!this.pauseRequested && this.currentStatus == MediaPlayer.Status.PAUSED) {
                    this.currentStatus = MediaPlayer.Status.PLAYING;
                }
                if (this.pauseRequested) {
                    Thread.sleep(10L);
                    continue;
                }
                int result = avformat.av_read_frame(this.formatContext, this.packet);
                if (result < 0) {
                    try {
                        WaterMedia.LOGGER.info(IT, "End of stream reached");
                        Thread.sleep(500L);
                        if (this.repeat()) {
                            WaterMedia.LOGGER.info(IT, "Repeating playback");
                            this.seekTarget = 0L;
                        } else {
                            WaterMedia.LOGGER.info(IT, "Playback ended naturally");
                            this.currentStatus = MediaPlayer.Status.ENDED;
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    if (this.currentStatus == MediaPlayer.Status.PLAYING) continue;
                    break;
                }
                try {
                    if (this.packet.stream_index() == this.videoStreamIndex && this.video) {
                        this.processVideoPacket();
                        continue;
                    }
                    if (this.packet.stream_index() != this.audioStreamIndex || !this.audio) continue;
                    this.processAudioPacket();
                }
                finally {
                    avcodec.av_packet_unref(this.packet);
                }
            }
            if (this.stopRequested) {
                this.currentStatus = MediaPlayer.Status.STOPPED;
            } else if (this.currentStatus == MediaPlayer.Status.PLAYING) {
                this.currentStatus = MediaPlayer.Status.ENDED;
            }
        }
        catch (Exception e) {
            WaterMedia.LOGGER.error(IT, "Error in player loop", (Throwable)e);
            this.currentStatus = MediaPlayer.Status.ERROR;
        }
        finally {
            this.cleanup();
        }
    }

    private boolean init() {
        try {
            this.packet = avcodec.av_packet_alloc();
            this.videoFrame = avutil.av_frame_alloc();
            this.audioFrame = avutil.av_frame_alloc();
            this.scaledFrame = avutil.av_frame_alloc();
            this.resampledFrame = avutil.av_frame_alloc();
            if (this.packet == null || this.videoFrame == null || this.audioFrame == null || this.scaledFrame == null || this.resampledFrame == null) {
                return false;
            }
            this.formatContext = avformat.avformat_alloc_context();
            if (avformat.avformat_open_input(this.formatContext, this.mrl.toString(), null, null) < 0) {
                return false;
            }
            if (avformat.avformat_find_stream_info(this.formatContext, (PointerPointer)null) < 0) {
                return false;
            }
            for (int i = 0; i < this.formatContext.nb_streams(); ++i) {
                AVStream stream = this.formatContext.streams(i);
                int codecType = stream.codecpar().codec_type();
                if (codecType == 0 && this.videoStreamIndex < 0 && this.video) {
                    this.videoStreamIndex = i;
                    this.videoTimeBase = FFMediaPlayer.av_q2d(stream.time_base());
                    continue;
                }
                if (codecType != 1 || this.audioStreamIndex >= 0 || !this.audio) continue;
                this.audioStreamIndex = i;
                this.audioTimeBase = FFMediaPlayer.av_q2d(stream.time_base());
            }
            if (this.video && this.videoStreamIndex >= 0) {
                AVCodec videoCodec = avcodec.avcodec_find_decoder(this.formatContext.streams(this.videoStreamIndex).codecpar().codec_id());
                if (videoCodec == null) {
                    return false;
                }
                this.videoCodecContext = avcodec.avcodec_alloc_context3(videoCodec);
                if (avcodec.avcodec_parameters_to_context(this.videoCodecContext, this.formatContext.streams(this.videoStreamIndex).codecpar()) < 0) {
                    return false;
                }
                if (avcodec.avcodec_open2(this.videoCodecContext, videoCodec, (PointerPointer)null) < 0) {
                    return false;
                }
                this.setVideoFormat(32993, this.videoCodecContext.width(), this.videoCodecContext.height());
                this.swsContext = swscale.sws_getContext(this.width(), this.height(), this.videoCodecContext.pix_fmt(), this.width(), this.height(), 28, 2, null, null, (double[])null);
                if (this.swsContext == null) {
                    return false;
                }
                this.scaledFrame.format(28);
                this.scaledFrame.width(this.width());
                this.scaledFrame.height(this.height());
                if (avutil.av_frame_get_buffer(this.scaledFrame, 32) < 0) {
                    return false;
                }
            }
            if (this.audio && this.audioStreamIndex >= 0) {
                AVStream audioStream = this.formatContext.streams(this.audioStreamIndex);
                AVCodecParameters codecParams = audioStream.codecpar();
                AVCodec audioCodec = avcodec.avcodec_find_decoder(codecParams.codec_id());
                if (audioCodec == null) {
                    return false;
                }
                this.audioCodecContext = avcodec.avcodec_alloc_context3(audioCodec);
                if (this.audioCodecContext == null) {
                    return false;
                }
                if (avcodec.avcodec_parameters_to_context(this.audioCodecContext, codecParams) < 0) {
                    return false;
                }
                if (avcodec.avcodec_open2(this.audioCodecContext, audioCodec, (PointerPointer)null) < 0) {
                    return false;
                }
                this.swrContext = swresample.swr_alloc();
                if (this.swrContext == null) {
                    return false;
                }
                AVChannelLayout inputLayout = new AVChannelLayout();
                AVChannelLayout outputLayout = new AVChannelLayout();
                if (codecParams.ch_layout().nb_channels() > 0) {
                    avutil.av_channel_layout_copy(inputLayout, codecParams.ch_layout());
                } else {
                    avutil.av_channel_layout_default(inputLayout, codecParams.ch_layout().nb_channels());
                }
                avutil.av_channel_layout_default(outputLayout, 2);
                avutil.av_opt_set_chlayout((Pointer)this.swrContext, "in_chlayout", inputLayout, 0);
                avutil.av_opt_set_int((Pointer)this.swrContext, "in_sample_rate", (long)codecParams.sample_rate(), 0);
                avutil.av_opt_set_sample_fmt((Pointer)this.swrContext, "in_sample_fmt", codecParams.format(), 0);
                avutil.av_opt_set_chlayout((Pointer)this.swrContext, "out_chlayout", outputLayout, 0);
                avutil.av_opt_set_int((Pointer)this.swrContext, "out_sample_rate", 44100L, 0);
                avutil.av_opt_set_sample_fmt((Pointer)this.swrContext, "out_sample_fmt", 1, 0);
                if (swresample.swr_init(this.swrContext) < 0) {
                    return false;
                }
                this.resampledFrame.format(1);
                this.resampledFrame.ch_layout().nb_channels(2);
                avutil.av_channel_layout_default(this.resampledFrame.ch_layout(), 2);
                this.resampledFrame.sample_rate(44100);
                this.resampledFrame.nb_samples(1024);
                return avutil.av_frame_get_buffer(this.resampledFrame, 0) >= 0;
            }
            return true;
        }
        catch (Exception e) {
            WaterMedia.LOGGER.error(IT, "Failed to initialize FFmpeg", (Throwable)e);
            return false;
        }
    }

    private void processVideoPacket() {
        if (avcodec.avcodec_send_packet(this.videoCodecContext, this.packet) < 0) {
            return;
        }
        while (avcodec.avcodec_receive_frame(this.videoCodecContext, this.videoFrame) >= 0) {
            double currentTime;
            double delay;
            double ptsInSeconds = (double)this.videoFrame.pts() * this.videoTimeBase;
            this.updateClock(ptsInSeconds);
            if (!this.audio && !this.pauseRequested && (delay = ptsInSeconds - (currentTime = (double)(System.nanoTime() - this.clockBaseTime) / 1.0E9 * (double)this.speedFactor)) > 0.0 && delay < 0.5) {
                try {
                    Thread.sleep((long)(delay * 1000.0));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            swscale.sws_scale(this.swsContext, this.videoFrame.data(), this.videoFrame.linesize(), 0, this.height(), this.scaledFrame.data(), this.scaledFrame.linesize());
            int stride = this.scaledFrame.linesize(0);
            if (this.videoBuffer == null) {
                this.videoBuffer = this.scaledFrame.data(0).asByteBuffer();
            }
            this.upload(this.videoBuffer, stride / 4);
        }
    }

    private void processAudioPacket() {
        if (avcodec.avcodec_send_packet(this.audioCodecContext, this.packet) < 0) {
            return;
        }
        while (avcodec.avcodec_receive_frame(this.audioCodecContext, this.audioFrame) >= 0) {
            double ptsInSeconds = (double)this.audioFrame.pts() * this.audioTimeBase;
            this.updateClock(ptsInSeconds);
            int samplesConverted = swresample.swr_convert(this.swrContext, this.resampledFrame.data(), this.resampledFrame.nb_samples(), this.audioFrame.data(), this.audioFrame.nb_samples());
            if (samplesConverted <= 0) continue;
            int dataSize = samplesConverted * 2 * 2;
            this.upload(this.resampledFrame.data(0).limit(dataSize).asBuffer().clear(), 4355, 44100, 2);
        }
    }

    private void updateClock(double ptsInSeconds) {
        if (this.audio && this.audioStreamIndex >= 0) {
            this.masterClock = ptsInSeconds;
            if (!this.clockPaused && this.clockBaseTime <= 0L) {
                this.clockBaseTime = System.nanoTime() - (long)(ptsInSeconds * 1.0E9);
            }
        } else if (!this.audio && this.video) {
            this.masterClock = ptsInSeconds;
            if (!this.clockPaused && this.clockBaseTime <= 0L) {
                this.clockBaseTime = System.nanoTime() - (long)(ptsInSeconds * 1.0E9);
            }
        }
    }

    private void cleanup() {
        this.running = false;
        if (this.swsContext != null) {
            swscale.sws_freeContext(this.swsContext);
            this.swsContext = null;
        }
        if (this.swrContext != null) {
            swresample.swr_free(this.swrContext);
            this.swrContext = null;
        }
        if (this.videoCodecContext != null) {
            avcodec.avcodec_free_context(this.videoCodecContext);
            this.videoCodecContext = null;
        }
        if (this.audioCodecContext != null) {
            avcodec.avcodec_free_context(this.audioCodecContext);
            this.audioCodecContext = null;
        }
        if (this.formatContext != null) {
            try {
                avformat.avformat_close_input(this.formatContext);
            }
            catch (Exception e) {
                WaterMedia.LOGGER.warn(IT, "Error closing format context", (Throwable)e);
            }
            this.formatContext = null;
        }
        if (this.videoFrame != null) {
            avutil.av_frame_free(this.videoFrame);
            this.videoFrame = null;
        }
        if (this.audioFrame != null) {
            avutil.av_frame_free(this.audioFrame);
            this.audioFrame = null;
        }
        if (this.scaledFrame != null) {
            avutil.av_frame_free(this.scaledFrame);
            this.scaledFrame = null;
        }
        if (this.resampledFrame != null) {
            avutil.av_frame_free(this.resampledFrame);
            this.resampledFrame = null;
        }
        if (this.packet != null) {
            avcodec.av_packet_free(this.packet);
            this.packet = null;
        }
        WaterMedia.LOGGER.info(IT, "Cleanup completed");
    }

    private static double av_q2d(AVRational a) {
        return (double)a.num() / (double)a.den();
    }

    private static long msFromSeconds(double seconds) {
        return (long)(seconds * 1000.0);
    }

    private static double secondsFromMs(long ms) {
        return (double)ms / 1000.0;
    }
}

