/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.media;

import java.io.File;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.bytedeco.ffmpeg.global.avformat;
import org.watermedia.WaterMedia;
import org.watermedia.api.WaterMediaAPI;
import org.watermedia.api.media.FFMediaPlayer;
import org.watermedia.api.media.MediaPlayer;
import org.watermedia.api.media.PicturePlayer;
import org.watermedia.api.media.VLMediaPlayer;
import org.watermedia.binaries.WaterMediaBinaries;
import org.watermedia.tools.NetTool;
import org.watermedia.videolan4j.VideoLan4J;
import org.watermedia.videolan4j.binding.internal.libvlc_instance_t;

public class MediaAPI
extends WaterMediaAPI {
    private static final Marker IT = MarkerManager.getMarker((String)MediaAPI.class.getSimpleName());
    protected static libvlc_instance_t VLC_INSTANCE;
    protected static boolean FFMPEG_LOADED;

    public static MediaPlayer getMediaPlayer(URI uri, Thread thread, Executor renderThreadEx, boolean video, boolean audio) {
        WaterMedia.checkIsClientSideOrThrow(MediaAPI.class);
        try {
            String[] type;
            URLConnection conn = uri.toURL().openConnection();
            if (conn instanceof HttpURLConnection) {
                HttpURLConnection http = (HttpURLConnection)conn;
                NetTool.validateHTTP200(http.getResponseCode(), uri);
            }
            if ((type = conn.getContentType().split("/"))[0].equals("image")) {
                return new PicturePlayer(uri, thread, renderThreadEx, video);
            }
            if (VLC_INSTANCE != null) {
                WaterMedia.LOGGER.debug(IT, "Creating LibVLC MediaPlayer for URI: {}", (Object)uri);
                return new VLMediaPlayer(uri, thread, renderThreadEx, video, audio);
            }
            if (FFMPEG_LOADED) {
                WaterMedia.LOGGER.debug(IT, "Creating FFMPEG MediaPlayer for URI: {}", (Object)uri);
                return new FFMediaPlayer(uri, thread, renderThreadEx, video, audio);
            }
            WaterMedia.LOGGER.error(IT, "Neither LibVLC nor FFMPEG are loaded, cannot create MediaPlayer for URI: {}", (Object)uri);
        }
        catch (Throwable t) {
            WaterMedia.LOGGER.error(IT, "Failed to create MediaPlayer for URI: {}", (Object)uri, (Object)t);
        }
        return null;
    }

    static libvlc_instance_t getVlcInstance() {
        WaterMedia.checkIsClientSideOrThrow(MediaAPI.class);
        return VLC_INSTANCE;
    }

    @Override
    public boolean start(WaterMedia instance) throws Exception {
        if (!instance.clientSide) {
            WaterMedia.LOGGER.warn(IT, "Detected server-side environment, lockdown mode enabled");
            return false;
        }
        WaterMedia.LOGGER.info(IT, "Starting WaterMedia Binaries extraction...");
        WaterMediaBinaries.start((String)instance.name, (Path)instance.tmp, (Path)instance.cwd, (boolean)true);
        WaterMedia.LOGGER.info(IT, "Starting LibVLC...");
        if (VideoLan4J.load()) {
            VLC_INSTANCE = VideoLan4J.createInstance("--no-quiet", "--verbose", "--file-logging", "--logfile=/logs/vlc.log", "--vout=direct3d11");
            WaterMedia.LOGGER.info(IT, "Created new LibVLC instance");
        } else {
            WaterMedia.LOGGER.error(IT, "Failed to load LibVLC");
        }
        try {
            WaterMedia.LOGGER.info(IT, "Starting FFMPEG...");
            Path ffmpegPath = WaterMediaBinaries.getBinaryPath((String)"ffmpeg");
            if (ffmpegPath != null && Files.exists(ffmpegPath, new LinkOption[0])) {
                String pathStr = ffmpegPath.toAbsolutePath().toString();
                System.setProperty("org.bytedeco.javacpp.platform.preloadpath", pathStr);
                System.setProperty("org.bytedeco.javacpp.pathsFirst", "true");
                String currentLibPath = System.getProperty("java.library.path");
                if (currentLibPath == null || currentLibPath.isEmpty()) {
                    System.setProperty("java.library.path", pathStr);
                } else if (!currentLibPath.contains(pathStr)) {
                    System.setProperty("java.library.path", pathStr + File.pathSeparator + currentLibPath);
                }
                WaterMedia.LOGGER.info(IT, "Configured JavaCPP with custom FFmpeg path: {}", (Object)pathStr);
            } else {
                WaterMedia.LOGGER.warn(IT, "FFmpeg binaries path not found, using JavaCPP defaults");
            }
            avformat.avformat_network_init();
            FFMPEG_LOADED = true;
            WaterMedia.LOGGER.info(IT, "FFMPEG started, running version {} under {}", (Object)avformat.avformat_version(), (Object)avformat.avformat_license());
        }
        catch (Throwable t) {
            WaterMedia.LOGGER.error(IT, "Failed to load FFMPEG", t);
        }
        if (VLC_INSTANCE == null && !FFMPEG_LOADED) {
            WaterMedia.LOGGER.fatal(IT, "LibVLC and FFMPEG are unable to be started in your environment, please report this issue to the WaterMedia's authors");
            return false;
        }
        return true;
    }

    @Override
    public boolean onlyClient() {
        return true;
    }

    @Override
    public void test() {
        WaterMedia.LOGGER.info(IT, "Testing LibVLC...");
        if (VideoLan4J.load()) {
            libvlc_instance_t instance = VideoLan4J.createInstance("--no-quiet", "--verbose", "--file-logging", "--logfile=/logs/vlc.log", "--vout=direct3d11");
            VideoLan4J.releaseInstance(instance);
        }
    }

    @Override
    public WaterMediaAPI.Priority priority() {
        return WaterMediaAPI.Priority.NORMAL;
    }

    @Override
    public void release(WaterMedia instance) {
        if (VLC_INSTANCE != null) {
            VideoLan4J.releaseInstance(VLC_INSTANCE);
        }
        if (FFMPEG_LOADED) {
            avformat.avformat_network_deinit();
        }
    }
}

