/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.media;

import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.lwjgl.openal.AL10;
import org.watermedia.WaterMedia;
import org.watermedia.api.audio.AudioAPI;
import org.watermedia.api.math.MathAPI;
import org.watermedia.api.render.RenderAPI;
import org.watermedia.tools.ThreadTool;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class MediaPlayer {
    private static final Marker IT = MarkerManager.getMarker((String)MediaPlayer.class.getSimpleName());
    public static final int NO_SIZE = -1;
    public static final int NO_TEXTURE = -1;
    protected final URI mrl;
    protected final Thread renderThread;
    protected final Executor renderThreadEx;
    protected boolean video;
    protected boolean audio;
    private int glChroma = 32993;
    private int width = -1;
    private int height = -1;
    private final int glTexture;
    private boolean firstFrame = true;
    protected final int alSources;
    private final int[] alBuffers = new int[4];
    private int alBufferIndex = 0;
    private boolean repeat;
    private float volume = 1.0f;
    private boolean muted = false;

    public MediaPlayer(URI mrl, Thread renderThread, Executor renderThreadEx, boolean video, boolean audio) {
        if (!video && !audio) {
            throw new IllegalArgumentException("media player must support at least one media playback.");
        }
        Objects.requireNonNull(mrl, "media player must have a valid media resource locator. (mrl)");
        Objects.requireNonNull(renderThread, "media player must have a valid render thread.");
        Objects.requireNonNull(renderThreadEx, "media player must have a valid render thread executor.");
        this.mrl = mrl;
        this.renderThread = renderThread;
        this.renderThreadEx = renderThreadEx;
        this.video = video;
        this.audio = audio;
        this.glTexture = video ? RenderAPI.genTexture() : -1;
        this.alSources = audio ? AudioAPI.genSource(this.alBuffers) : -1;
    }

    public void setVideoFormat(int chroma, int width, int height) {
        if (chroma != 6408 && chroma != 32993) {
            throw new IllegalArgumentException("Unsupported chroma format: " + chroma);
        }
        this.glChroma = chroma;
        this.width = width;
        this.height = height;
        this.firstFrame = true;
        WaterMedia.LOGGER.debug(IT, "Set video format: chroma={}, width={}, height={}", (Object)chroma, (Object)width, (Object)height);
    }

    protected void upload(ByteBuffer data, int alFormat, int sampleRate, int channels) {
        int buffer;
        if (!this.audio) {
            throw new IllegalStateException("MediaPlayer was built with no audio support");
        }
        if (alFormat != 4352 && alFormat != 4353 && alFormat != 4354 && alFormat != 4355) {
            throw new IllegalArgumentException("Unsupported audio format: " + alFormat);
        }
        if (channels < 1 || channels > 2) {
            throw new IllegalArgumentException("Unsupported channel count: " + channels);
        }
        if (channels == 1 && alFormat != 4352 && alFormat != 4353) {
            throw new IllegalArgumentException("Mono format expected for single channel audio.");
        }
        if (channels == 2 && alFormat != 4354 && alFormat != 4355) {
            throw new IllegalArgumentException("Stereo format expected for dual channel audio.");
        }
        if (this.alBufferIndex < this.alBuffers.length) {
            buffer = this.alBuffers[this.alBufferIndex++];
        } else {
            while (AL10.alGetSourcei((int)this.alSources, (int)4118) <= 0) {
                ThreadTool.sleep(1L);
            }
            buffer = AL10.alSourceUnqueueBuffers((int)this.alSources);
        }
        AL10.alBufferData((int)buffer, (int)alFormat, (ByteBuffer)data, (int)sampleRate);
        AL10.alSourceQueueBuffers((int)this.alSources, (int)buffer);
        if (AL10.alGetSourcei((int)this.alSources, (int)4112) != 4114) {
            AL10.alSourcePlay((int)this.alSources);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void upload(ByteBuffer nativeBuffer, int stride) {
        if (this.width == -1 || this.height == -1) {
            return;
        }
        if (this.renderThread != Thread.currentThread()) {
            this.renderThreadEx.execute(() -> this.upload(nativeBuffer, stride));
            return;
        }
        if (!this.video) {
            throw new IllegalStateException("MediaPlayer was built with no video support");
        }
        if (this.glChroma != 6408 && this.glChroma != 32993) {
            throw new IllegalArgumentException("Unsupported chroma format: " + this.glChroma);
        }
        if (nativeBuffer == null) {
            throw new IllegalArgumentException("Native buffers cannot be null or empty.");
        }
        ByteBuffer byteBuffer = nativeBuffer;
        synchronized (byteBuffer) {
            RenderAPI.uploadTexture(this.glTexture, nativeBuffer, stride, this.width, this.height, this.glChroma, this.firstFrame);
            this.firstFrame = false;
        }
    }

    public boolean isVideo() {
        return this.video;
    }

    public boolean isAudio() {
        return this.audio;
    }

    public final int width() {
        return this.width;
    }

    public final int height() {
        return this.height;
    }

    public int texture() {
        return this.glTexture;
    }

    public abstract boolean previousFrame();

    public abstract boolean nextFrame();

    public void volume(int volume) {
        this.volume = (float)MathAPI.clamp(0, 100, volume) / 100.0f;
        this.muted = this.volume < 1.0f;
        AL10.alSourcef((int)this.alSources, (int)4106, (float)(this.muted ? 0.0f : this.volume));
    }

    public int volume() {
        return (int)(this.volume * 100.0f);
    }

    public void mute(boolean mute) {
        this.muted = mute;
        AL10.alSourcef((int)this.alSources, (int)4106, (float)(mute ? 0.0f : this.volume));
    }

    public boolean mute() {
        return this.muted;
    }

    public abstract void start();

    public abstract void startPaused();

    public abstract boolean resume();

    public abstract boolean pause();

    public abstract boolean pause(boolean var1);

    public abstract boolean stop();

    public abstract boolean togglePlay();

    public abstract boolean seek(long var1);

    public abstract long time();

    public abstract boolean skipTime(long var1);

    public abstract boolean seekQuick(long var1);

    public abstract boolean foward();

    public abstract boolean rewind();

    public abstract float speed();

    public abstract boolean speed(float var1);

    public abstract long duration();

    public boolean repeat() {
        return this.repeat;
    }

    public boolean repeat(boolean repeat) {
        this.repeat = repeat;
        return this.repeat;
    }

    public abstract Status status();

    public boolean waiting() {
        return this.status() == Status.WAITING;
    }

    public boolean loading() {
        return this.status() == Status.LOADING;
    }

    public boolean buffering() {
        return this.status() == Status.BUFFERING;
    }

    public boolean paused() {
        return this.status() == Status.PAUSED;
    }

    public boolean playing() {
        return this.status() == Status.PLAYING;
    }

    public boolean stopped() {
        return this.status() == Status.STOPPED;
    }

    public boolean ended() {
        return this.status() == Status.ENDED;
    }

    public boolean error() {
        return this.status() == Status.ERROR;
    }

    @Deprecated
    public abstract boolean validSource();

    public abstract boolean liveSource();

    public abstract boolean canSeek();

    public abstract boolean canPause();

    public abstract boolean canPlay();

    public void release() {
        if (this.video && this.glTexture != -1) {
            RenderAPI.delTexture(this.glTexture);
        }
        if (this.audio && this.alSources != -1) {
            AL10.alSourceStop((int)this.alSources);
            AL10.alDeleteSources((int)this.alSources);
            AL10.alDeleteBuffers((int[])this.alBuffers);
        }
    }

    public static enum Status {
        WAITING,
        LOADING,
        BUFFERING,
        PLAYING,
        PAUSED,
        STOPPED,
        ENDED,
        ERROR;

        private static final Status[] VALUES;

        public static Status of(int value) {
            return VALUES[value];
        }

        static {
            VALUES = Status.values();
        }
    }
}

