/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.media;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.watermedia.WaterMedia;
import org.watermedia.api.decode.DecoderAPI;
import org.watermedia.api.decode.Image;
import org.watermedia.api.media.MediaPlayer;
import org.watermedia.tools.IOTool;
import org.watermedia.tools.NetTool;
import org.watermedia.tools.ThreadTool;

public final class PicturePlayer
extends MediaPlayer {
    private static final Marker IT = MarkerManager.getMarker((String)PicturePlayer.class.getSimpleName());
    private static final Thread PLAYER_THREAD = ThreadTool.createStartedLoop("PicturePlayerThread", PicturePlayer::playerLoop);
    private static final ScheduledExecutorService FETCH_EXECUTOR = Executors.newScheduledThreadPool(ThreadTool.minThreads());
    private static final ConcurrentLinkedQueue<PicturePlayer> ACTIVE_PLAYERS = new ConcurrentLinkedQueue();
    private volatile Image images = null;
    private boolean paused = false;
    private float speed = 1.0f;
    private volatile MediaPlayer.Status status = MediaPlayer.Status.WAITING;
    private volatile boolean triggerStop = false;
    private volatile boolean triggerResume = false;
    private volatile boolean triggerPause = false;
    private volatile boolean triggerNextFrame = false;
    private volatile boolean triggerPrevFrame = false;
    private volatile long time = 0L;
    private int lastFrameIndex = -1;
    private static long lastTick = System.currentTimeMillis();

    public PicturePlayer(URI mrl, Thread renderThread, Executor renderThreadEx, boolean video) {
        super(mrl, renderThread, renderThreadEx, video, false);
    }

    @Override
    public void start() {
        FETCH_EXECUTOR.execute(this::fetchImage);
    }

    @Override
    public void startPaused() {
        this.start();
        this.triggerPause = true;
    }

    private void fetchImage() {
        this.status = MediaPlayer.Status.LOADING;
        try (NetTool.Request request = new NetTool.Request(this.mrl.toURL(), "GET", null);){
            String type = request.getContentType();
            if (type == null || !type.startsWith("image/")) {
                throw new IllegalArgumentException("Invalid media type: " + type);
            }
            WaterMedia.LOGGER.debug(IT, "Fetching image from: {} with content type {}", (Object)this.mrl, (Object)type);
            int code = request.getResponseCode();
            boolean valid = NetTool.validateHTTP200(code, this.mrl);
            if (valid) {
                this.status = MediaPlayer.Status.BUFFERING;
            }
            WaterMedia.LOGGER.debug(IT, "Server Response code: {}, running decoding", (Object)code);
            this.images = DecoderAPI.decodeImage(IOTool.readAllBytes(request.getInputStream()));
            MediaPlayer.Status status = this.status = this.triggerPause ? MediaPlayer.Status.PAUSED : MediaPlayer.Status.PLAYING;
            if (this.images == null || this.images.frames() == null || this.images.frames().length == 0) {
                throw new IOException("No frames found in the media: " + String.valueOf(this.mrl));
            }
            this.setVideoFormat(32993, this.images.width(), this.images.height());
            ACTIVE_PLAYERS.add(this);
            WaterMedia.LOGGER.debug(IT, "Successfully fetched image: {} with dimensions {}x{} and delay {}", (Object)this.mrl, (Object)this.images.width(), (Object)this.images.height(), (Object)this.images.delay());
        }
        catch (Throwable e) {
            WaterMedia.LOGGER.error(IT, "Failed to open media: {}", (Object)this.mrl, (Object)e);
            this.status = MediaPlayer.Status.ERROR;
        }
    }

    @Override
    public boolean previousFrame() {
        if (!this.paused()) {
            return false;
        }
        this.triggerPrevFrame = true;
        return true;
    }

    @Override
    public boolean nextFrame() {
        if (!this.paused()) {
            return false;
        }
        this.triggerNextFrame = true;
        return true;
    }

    @Override
    public boolean resume() {
        return this.pause(false);
    }

    @Override
    public boolean pause() {
        return this.pause(true);
    }

    @Override
    public boolean pause(boolean paused) {
        if (paused) {
            this.triggerPause = true;
            this.triggerResume = false;
        } else {
            this.triggerResume = true;
            this.triggerPause = false;
        }
        return true;
    }

    @Override
    public boolean stop() {
        this.triggerStop = true;
        return true;
    }

    @Override
    public boolean togglePlay() {
        return this.paused() ? this.resume() : this.pause();
    }

    @Override
    public boolean seek(long time) {
        if (this.images == null || this.images.frames() == null || this.images.frames().length == 0) {
            WaterMedia.LOGGER.warn(IT, "Cannot seek, no frames available for: {}", (Object)this.mrl);
            return false;
        }
        if (time < 0L || time > this.images.duration()) {
            WaterMedia.LOGGER.warn(IT, "Seek time out of bounds for: {}. Time: {}, Duration: {}", (Object)this.mrl, (Object)time, (Object)this.images.duration());
            return false;
        }
        this.time = time;
        this.lastFrameIndex = -1;
        return true;
    }

    @Override
    public boolean seekQuick(long time) {
        return this.seek(time);
    }

    @Override
    public boolean skipTime(long time) {
        return this.seek(this.duration() + time);
    }

    @Override
    public boolean foward() {
        return this.seek(this.duration() + 1000L);
    }

    @Override
    public boolean rewind() {
        return this.seek(this.duration() - 1000L);
    }

    @Override
    public float speed() {
        return this.speed;
    }

    @Override
    public boolean speed(float speed) {
        this.speed = speed;
        return true;
    }

    @Override
    public MediaPlayer.Status status() {
        return this.status;
    }

    @Override
    public boolean validSource() {
        return this.images != null && this.images.frames() != null && this.images.frames().length > 0;
    }

    @Override
    public boolean liveSource() {
        return false;
    }

    @Override
    public boolean canSeek() {
        return this.duration() > 1000L;
    }

    @Override
    public boolean canPause() {
        return this.validSource();
    }

    @Override
    public boolean canPlay() {
        return this.validSource();
    }

    @Override
    public long duration() {
        return this.images.duration();
    }

    @Override
    public long time() {
        return this.time;
    }

    @Override
    public void release() {
        ACTIVE_PLAYERS.remove(this);
        this.images = null;
        super.release();
    }

    private static void playerLoop() {
        while (!Thread.currentThread().isInterrupted()) {
            ThreadTool.sleep(10L);
            block1: for (PicturePlayer player : ACTIVE_PLAYERS) {
                long currentTime;
                boolean detained;
                if (player.triggerPause && !player.paused) {
                    player.paused = true;
                    player.triggerPause = false;
                    player.status = MediaPlayer.Status.PAUSED;
                }
                if (player.triggerResume && player.paused) {
                    player.paused = false;
                    player.triggerResume = false;
                    player.status = MediaPlayer.Status.PLAYING;
                }
                if (player.triggerStop) {
                    player.release();
                    continue;
                }
                boolean bl = detained = player.stopped() || player.ended() || player.paused() || player.error();
                if (detained && !player.triggerNextFrame && !player.triggerPrevFrame || player.images == null) continue;
                long now = System.currentTimeMillis();
                long delta = now - lastTick;
                long l = currentTime = detained ? player.time : player.time + (long)((float)delta * player.speed);
                if (currentTime >= player.images.duration()) {
                    if (player.repeat()) {
                        player.time = 0L;
                    } else {
                        player.time = player.images.duration();
                        player.status = MediaPlayer.Status.ENDED;
                        continue;
                    }
                }
                long frameTime = currentTime;
                long[] delays = player.images.delay();
                for (int i = 0; i < delays.length; ++i) {
                    if ((frameTime -= delays[i]) > 0L) continue;
                    if (detained && player.triggerNextFrame) {
                        player.triggerNextFrame = false;
                        player.triggerPrevFrame = false;
                        if (i + 1 >= delays.length) continue block1;
                        ++i;
                    }
                    if (detained && player.triggerPrevFrame) {
                        player.triggerNextFrame = false;
                        player.triggerPrevFrame = false;
                        if (i - 1 <= 0) continue block1;
                        --i;
                    }
                    if (player.lastFrameIndex != i) {
                        player.lastFrameIndex = i;
                        player.upload(player.images.frames()[i], 0);
                    }
                    player.time = currentTime;
                    continue block1;
                }
            }
            lastTick = System.currentTimeMillis();
        }
    }
}

