/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.media;

import com.sun.jna.Pointer;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.lwjgl.openal.AL10;
import org.watermedia.WaterMedia;
import org.watermedia.api.media.MediaAPI;
import org.watermedia.api.media.MediaPlayer;
import org.watermedia.videolan4j.VideoLan4J;
import org.watermedia.videolan4j.binding.internal.libvlc_audio_drain_cb;
import org.watermedia.videolan4j.binding.internal.libvlc_audio_flush_cb;
import org.watermedia.videolan4j.binding.internal.libvlc_audio_pause_cb;
import org.watermedia.videolan4j.binding.internal.libvlc_audio_play_cb;
import org.watermedia.videolan4j.binding.internal.libvlc_audio_resume_cb;
import org.watermedia.videolan4j.binding.internal.libvlc_audio_set_volume_cb;
import org.watermedia.videolan4j.binding.internal.libvlc_callback_t;
import org.watermedia.videolan4j.binding.internal.libvlc_display_callback_t;
import org.watermedia.videolan4j.binding.internal.libvlc_event_e;
import org.watermedia.videolan4j.binding.internal.libvlc_event_manager_t;
import org.watermedia.videolan4j.binding.internal.libvlc_lock_callback_t;
import org.watermedia.videolan4j.binding.internal.libvlc_media_player_t;
import org.watermedia.videolan4j.binding.internal.libvlc_media_stats_t;
import org.watermedia.videolan4j.binding.internal.libvlc_media_t;
import org.watermedia.videolan4j.binding.internal.libvlc_unlock_callback_t;
import org.watermedia.videolan4j.binding.internal.libvlc_video_cleanup_cb;
import org.watermedia.videolan4j.binding.internal.libvlc_video_format_cb;
import org.watermedia.videolan4j.binding.lib.LibC;
import org.watermedia.videolan4j.binding.lib.LibVlc;
import org.watermedia.videolan4j.tools.AudioFormat;
import org.watermedia.videolan4j.tools.Buffers;
import org.watermedia.videolan4j.tools.Chroma;

public final class VLMediaPlayer
extends MediaPlayer {
    private static final Marker IT = MarkerManager.getMarker((String)VLMediaPlayer.class.getSimpleName());
    private static final Chroma CHROMA = Chroma.RV32;
    private static final AudioFormat AUDIO_FORMAT = AudioFormat.S16N_STEREO_96;
    private ByteBuffer nativeBuffer = null;
    private Pointer nativePointer = null;
    private final libvlc_media_player_t rawPlayer;
    private final libvlc_media_t rawMedia;
    private final libvlc_media_stats_t rawStats = null;
    private final libvlc_event_manager_t rawEvents;
    private final libvlc_callback_t endReachedCallback = (event, userData) -> this.renderThreadEx.execute(this::start);
    private final libvlc_video_format_cb formatCB = (opaque, chromaPointer, widthPointer, heightPointer, pitchesPointer, linesPointer) -> {
        byte[] chromaBytes = CHROMA.chroma();
        chromaPointer.getPointer().write(0L, chromaBytes, 0, Math.min(chromaBytes.length, 4));
        this.setVideoFormat(32993, widthPointer.getValue(), heightPointer.getValue());
        int[] pitchValues = CHROMA.getPitches(this.width());
        int[] lineValues = CHROMA.getLines(this.height());
        int planeCount = pitchValues.length;
        pitchesPointer.getPointer().write(0L, pitchValues, 0, pitchValues.length);
        linesPointer.getPointer().write(0L, lineValues, 0, lineValues.length);
        this.nativeBuffer = Buffers.alloc(pitchValues[0] * lineValues[0]);
        this.nativePointer = Pointer.createConstant((long)Buffers.address(this.nativeBuffer));
        LibC.memoryLock(this.nativePointer, this.nativeBuffer.capacity());
        return planeCount;
    };
    private final libvlc_video_cleanup_cb cleanupCB = opaque -> {
        if (this.nativeBuffer == null) {
            return;
        }
        LibC.memoryUnlock(this.nativePointer, this.nativeBuffer.capacity());
        this.nativeBuffer = null;
        this.nativePointer = null;
    };
    private final libvlc_lock_callback_t lockCB = (opaque, planes) -> {
        if (this.nativeBuffer == null) {
            return null;
        }
        ByteBuffer byteBuffer = this.nativeBuffer;
        synchronized (byteBuffer) {
            planes.getPointer().setPointer(0L, this.nativePointer);
        }
        return null;
    };
    private final libvlc_display_callback_t displayCB = (opaque, picture) -> this.upload(this.nativeBuffer, 0);
    private final libvlc_unlock_callback_t unlockCB = (opaque, picture, plane) -> {};
    private final libvlc_audio_play_cb playCB = (pointer, samples, count, pts) -> this.upload(samples.getByteBuffer(0L, (long)AUDIO_FORMAT.calculateBufferSize(count)), 4355, AUDIO_FORMAT.getSampleRate(), AUDIO_FORMAT.getChannelCount());
    private final libvlc_audio_pause_cb pauseCB = (data, pts) -> {
        if (AL10.alGetSourcei((int)this.alSources, (int)4112) != 4115) {
            AL10.alSourcePause((int)this.alSources);
        }
    };
    private final libvlc_audio_resume_cb resumeCB = (data, pts) -> {
        if (AL10.alGetSourcei((int)this.alSources, (int)4112) != 4114) {
            AL10.alSourcePlay((int)this.alSources);
        }
    };
    private final libvlc_audio_flush_cb flushCB = (data, pts) -> {};
    private final libvlc_audio_drain_cb drainCB = data -> {};
    private final libvlc_audio_set_volume_cb volumeCB = (data, volume, mute) -> AL10.alSourcef((int)this.alSources, (int)4106, (float)volume);

    public VLMediaPlayer(URI mrl, Thread renderThread, Executor renderThreadEx, boolean video, boolean audio) {
        super(mrl, renderThread, renderThreadEx, video, audio);
        this.rawPlayer = VideoLan4J.createMediaPlayer(MediaAPI.getVlcInstance());
        this.rawMedia = VideoLan4J.createMediaInstance(MediaAPI.getVlcInstance(), this.mrl);
        LibVlc.libvlc_media_player_set_media(this.rawPlayer, this.rawMedia);
        if (this.isAudio()) {
            LibVlc.libvlc_audio_set_callbacks(this.rawPlayer, this.playCB, this.pauseCB, this.resumeCB, this.flushCB, this.drainCB, Pointer.NULL);
            LibVlc.libvlc_audio_set_volume_callback(this.rawPlayer, this.volumeCB);
            LibVlc.libvlc_audio_set_format(this.rawPlayer, AUDIO_FORMAT.getFormatName(), AUDIO_FORMAT.getSampleRate(), AUDIO_FORMAT.getChannelCount());
        }
        if (this.isVideo()) {
            LibVlc.libvlc_video_set_format_callbacks(this.rawPlayer, this.formatCB, this.cleanupCB);
            LibVlc.libvlc_video_set_callbacks(this.rawPlayer, this.lockCB, this.unlockCB, this.displayCB, Pointer.NULL);
        }
        this.rawEvents = LibVlc.libvlc_media_player_event_manager(this.rawPlayer);
        LibVlc.libvlc_event_attach(this.rawEvents, libvlc_event_e.libvlc_MediaPlayerEndReached.intValue(), this.endReachedCallback, null);
    }

    @Override
    public boolean previousFrame() {
        WaterMedia.LOGGER.warn(IT, "Prev frame is not supported by VLC Media Player");
        return false;
    }

    @Override
    public boolean nextFrame() {
        LibVlc.libvlc_media_player_next_frame(this.rawPlayer);
        return true;
    }

    @Override
    public void start() {
        LibVlc.libvlc_media_player_play(this.rawPlayer);
    }

    @Override
    public void startPaused() {
        LibVlc.libvlc_media_add_option(this.rawMedia, "start-paused");
        this.start();
    }

    @Override
    public boolean resume() {
        return this.pause(false);
    }

    @Override
    public boolean pause() {
        return this.pause(true);
    }

    @Override
    public boolean pause(boolean paused) {
        LibVlc.libvlc_media_player_set_pause(this.rawPlayer, paused ? 1 : 0);
        return false;
    }

    @Override
    public boolean stop() {
        LibVlc.libvlc_media_player_stop(this.rawPlayer);
        return true;
    }

    @Override
    public boolean togglePlay() {
        if (this.status() == MediaPlayer.Status.PLAYING) {
            return this.pause();
        }
        if (this.status() == MediaPlayer.Status.PAUSED) {
            return this.resume();
        }
        if (this.status() == MediaPlayer.Status.STOPPED) {
            this.start();
            return true;
        }
        return false;
    }

    @Override
    public boolean seek(long time) {
        LibVlc.libvlc_media_player_set_time(this.rawPlayer, Math.max(time, 0L));
        return true;
    }

    @Override
    public boolean skipTime(long time) {
        long current = this.time();
        if (current != -1L) {
            return this.seek(current + time);
        }
        return false;
    }

    @Override
    public boolean seekQuick(long time) {
        return this.seek(time);
    }

    @Override
    public boolean foward() {
        this.seek(this.time() + 5000L);
        return true;
    }

    @Override
    public boolean rewind() {
        this.seek(this.time() - 5000L);
        return true;
    }

    @Override
    public float speed() {
        return LibVlc.libvlc_media_player_get_rate(this.rawPlayer);
    }

    @Override
    public boolean speed(float speed) {
        return LibVlc.libvlc_media_player_set_rate(this.rawPlayer, Math.max(speed, 0.1f)) != -1;
    }

    @Override
    public MediaPlayer.Status status() {
        return MediaPlayer.Status.of(LibVlc.libvlc_media_player_get_state(this.rawPlayer));
    }

    @Override
    public boolean playing() {
        return LibVlc.libvlc_media_player_is_playing(this.rawPlayer) == 1;
    }

    @Override
    public boolean validSource() {
        return this.rawMedia != null;
    }

    @Override
    public boolean liveSource() {
        return false;
    }

    @Override
    public boolean canSeek() {
        return LibVlc.libvlc_media_player_is_seekable(this.rawPlayer) == 1;
    }

    @Override
    public boolean canPause() {
        return LibVlc.libvlc_media_player_can_pause(this.rawPlayer) == 1;
    }

    @Override
    public boolean canPlay() {
        return LibVlc.libvlc_media_player_will_play(this.rawPlayer) == 1;
    }

    @Override
    public long duration() {
        return LibVlc.libvlc_media_player_get_length(this.rawPlayer);
    }

    @Override
    public long time() {
        return LibVlc.libvlc_media_player_get_time(this.rawPlayer);
    }

    @Override
    public void release() {
        LibVlc.libvlc_event_detach(this.rawEvents, libvlc_event_e.libvlc_MediaListEndReached.intValue(), this.endReachedCallback, null);
        LibVlc.libvlc_media_release(this.rawMedia);
        LibVlc.libvlc_media_player_release(this.rawPlayer);
        this.nativeBuffer = null;
        this.nativePointer = null;
        super.release();
    }

    private libvlc_media_stats_t getMediaStats() {
        if (LibVlc.libvlc_media_get_stats(this.rawMedia, this.rawStats) != 0) {
            throw new IllegalStateException("Failed to get media stats");
        }
        return new libvlc_media_stats_t();
    }
}

