/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.media.data;

public enum MediaQuality {
    LOWEST(240),
    LOWER(480),
    LOW(540),
    AVERAGE(720),
    HIGH(1080),
    HIGHER(1440),
    HIGHEST(2160);

    private final int threadshool;
    public static final MediaQuality[] VALUES;

    private MediaQuality(int threshold) {
        this.threadshool = threshold;
    }

    public static MediaQuality calculate(int width) {
        if (width >= MediaQuality.LOWEST.threadshool && width < MediaQuality.LOWER.threadshool) {
            return LOWEST;
        }
        if (width >= MediaQuality.LOWER.threadshool && width < MediaQuality.LOW.threadshool) {
            return LOWER;
        }
        if (width >= MediaQuality.LOW.threadshool && width < MediaQuality.AVERAGE.threadshool) {
            return LOW;
        }
        if (width >= MediaQuality.AVERAGE.threadshool && width < MediaQuality.HIGH.threadshool) {
            return AVERAGE;
        }
        if (width >= MediaQuality.HIGH.threadshool && width < MediaQuality.HIGHER.threadshool) {
            return HIGH;
        }
        if (width >= MediaQuality.HIGHER.threadshool && width < MediaQuality.HIGHEST.threadshool) {
            return HIGHER;
        }
        return HIGHEST;
    }

    public MediaQuality getNext() {
        int ordinal = this.ordinal() + 1;
        if (ordinal >= VALUES.length) {
            return null;
        }
        return VALUES[ordinal];
    }

    public MediaQuality getBack() {
        int ordinal = this.ordinal() - 1;
        if (ordinal <= 0) {
            return null;
        }
        return VALUES[ordinal];
    }

    static {
        VALUES = MediaQuality.values();
    }
}

