/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.media.data;

public enum MediaType {
    IMAGE,
    AUDIO,
    VIDEO,
    SUBTITLES,
    UNKNOWN;


    public static MediaType getByMimetype(String mimetype) {
        String[] mm = mimetype.split("/");
        String type = mm[0];
        String format = mm.length == 1 ? null : mm[1].toLowerCase();
        return switch (type) {
            case "video" -> VIDEO;
            case "audio" -> AUDIO;
            case "text" -> {
                if (format != null && (format.equals("str") || format.equals("plain"))) {
                    yield SUBTITLES;
                }
                yield UNKNOWN;
            }
            default -> UNKNOWN;
        };
    }
}

