/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.render;

import java.nio.ByteBuffer;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.lwjgl.opengl.GL11;
import org.lwjgl.system.MemoryUtil;
import org.watermedia.WaterMedia;
import org.watermedia.api.WaterMediaAPI;
import org.watermedia.api.render.support.DefaultGlManager;
import org.watermedia.api.render.support.GlManager;
import org.watermedia.videolan4j.VideoLan4J;

public class RenderAPI
extends WaterMediaAPI {
    private static final Marker IT = MarkerManager.getMarker((String)RenderAPI.class.getSimpleName());
    private static GlManager GL_MANAGER;
    private static final int NONE = 0;
    private static final long NULL = 0L;

    public static void setCustomGlManager(GlManager manager) {
        WaterMedia.checkIsClientSideOrThrow(RenderAPI.class);
        GL_MANAGER = manager;
    }

    public static int genTexture() {
        WaterMedia.checkIsClientSideOrThrow(RenderAPI.class);
        int tex = GL11.glGenTextures();
        GL_MANAGER.bindTexture(3553, tex);
        GL_MANAGER.texParameter(3553, 10242, 33071);
        GL_MANAGER.texParameter(3553, 10243, 33071);
        GL_MANAGER.texParameter(3553, 10241, 9729);
        GL_MANAGER.texParameter(3553, 10240, 9729);
        GL_MANAGER.bindTexture(3553, 0);
        return tex;
    }

    public static void delTexture(int texture) {
        WaterMedia.checkIsClientSideOrThrow(RenderAPI.class);
        GL_MANAGER.delTexture(texture);
    }

    public static void delTexture(int ... textures) {
        WaterMedia.checkIsClientSideOrThrow(RenderAPI.class);
        GL_MANAGER.delTexture(textures);
    }

    public static void uploadTexture(int texture, ByteBuffer buffers, int stride, int width, int height, int format, boolean firstFrame) {
        WaterMedia.checkIsClientSideOrThrow(RenderAPI.class);
        GL_MANAGER.bindTexture(3553, texture);
        GL_MANAGER.pixelStore(3314, stride);
        GL_MANAGER.pixelStore(3316, 0);
        GL_MANAGER.pixelStore(3315, 0);
        if (firstFrame) {
            GL_MANAGER.texImage2D(3553, 0, format, width, height, 0, format, 33639, buffers);
        } else {
            GL_MANAGER.texSubImage2D(3553, 0, 0, 0, width, height, format, 33639, buffers);
        }
    }

    @Override
    public boolean start(WaterMedia instance) throws Exception {
        GL_MANAGER = new DefaultGlManager();
        VideoLan4J.setBufferAllocator(MemoryUtil::memAlignedAlloc);
        VideoLan4J.setBufferDeallocator(MemoryUtil::memAlignedFree);
        return true;
    }

    @Override
    public boolean onlyClient() {
        return true;
    }

    @Override
    public void test() {
    }

    @Override
    public WaterMediaAPI.Priority priority() {
        return WaterMediaAPI.Priority.HIGH;
    }

    @Override
    public void release(WaterMedia instance) {
    }
}

