/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.tools;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;

public class NetTool {
    public static boolean validateHTTP200(int code, URI uri) throws IOException {
        switch (code) {
            case -1: 
            case 200: 
            case 304: {
                return true;
            }
            case 414: {
                throw new IOException("Request take too long to:" + String.valueOf(uri));
            }
            case 400: {
                throw new IOException("Bad request to: " + String.valueOf(uri));
            }
            case 401: {
                throw new IOException("Unauthorized access to: " + String.valueOf(uri));
            }
            case 403: {
                throw new IOException("Forbidden access to: " + String.valueOf(uri));
            }
            case 404: {
                throw new IOException("Media not found: " + String.valueOf(uri));
            }
            case 411: {
                throw new IOException("Length required for: " + String.valueOf(uri));
            }
            case 500: {
                throw new IOException("Internal server error for: " + String.valueOf(uri));
            }
            case 503: {
                throw new IOException("Service unavailable for: " + String.valueOf(uri));
            }
            case 504: {
                throw new IOException("Gateway timeout for: " + String.valueOf(uri));
            }
        }
        throw new IOException("Unexpected response code: " + code);
    }

    public static class Request
    implements AutoCloseable {
        private final URL url;
        private final String method;
        private final String body;
        private final URLConnection connection;

        public Request(URL url, String method, String body) throws IOException {
            this.url = url;
            this.method = method;
            this.body = body;
            this.connection = url.openConnection();
        }

        public URL getUrl() {
            return this.url;
        }

        public String getMethod() {
            return this.method;
        }

        public String getBody() {
            return this.body;
        }

        public String getContentType() {
            return this.connection.getContentType();
        }

        public int getResponseCode() throws IOException {
            URLConnection uRLConnection = this.connection;
            if (uRLConnection instanceof HttpURLConnection) {
                HttpURLConnection http = (HttpURLConnection)uRLConnection;
                return http.getResponseCode();
            }
            return -1;
        }

        public InputStream getInputStream() throws IOException {
            return this.connection.getInputStream();
        }

        @Override
        public void close() {
            URLConnection uRLConnection = this.connection;
            if (uRLConnection instanceof HttpURLConnection) {
                HttpURLConnection http = (HttpURLConnection)uRLConnection;
                http.disconnect();
            }
        }
    }
}

