/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.tools;

import java.util.HashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class ThreadTool {
    public static final HashMap<String, Integer> THREADS = new HashMap();

    public static boolean tryAdquireLock(Semaphore semaphore, long timeout, TimeUnit unit) {
        try {
            return semaphore.tryAcquire(timeout, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public static void sleep(long timeoutMillis) {
        try {
            Thread.sleep(timeoutMillis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static Thread createStartedLoop(String name, Runnable runnable) {
        int c = THREADS.computeIfAbsent(name, k -> 0);
        Thread t = new Thread(() -> {
            while (!Thread.currentThread().isInterrupted()) {
                runnable.run();
            }
        }, name + "-" + c);
        THREADS.put(name, c + 1);
        t.setDaemon(true);
        t.setPriority(5);
        t.start();
        return t;
    }

    public static int maxThreads() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static int minThreads() {
        int count = ThreadTool.maxThreads();
        if (count <= 2) {
            return 1;
        }
        if (count <= 8) {
            return 2;
        }
        if (count <= 16) {
            return 3;
        }
        if (count <= 32) {
            return 4;
        }
        if (count <= 64) {
            return 6;
        }
        return 8;
    }
}

