/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.binding.lib;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import org.watermedia.videolan4j.binding.lib.Kernel32;

public interface LibC
extends Library {
    public static final LibC INSTANCE = (LibC)Native.load((String)(Platform.isWindows() ? "msvcrt" : "c"), LibC.class);

    public static int printf(ByteBuffer str, int size, String format, Pointer args) {
        return INSTANCE.vsnprintf(str, size, format, args);
    }

    public static int memoryLock(Pointer addr, long length) {
        if (Platform.isWindows()) {
            return Kernel32.memoryLock(addr, length);
        }
        return INSTANCE.mlock(addr, new NativeLong(length));
    }

    public static int memoryUnlock(Pointer addr, long length) {
        if (Platform.isWindows()) {
            return Kernel32.memoryUnlock(addr, length);
        }
        return INSTANCE.munlock(addr, new NativeLong(length));
    }

    public static int setEnv(String name, String value, int overwrite) {
        if (Platform.isWindows()) {
            return INSTANCE._putenv(name + "=" + value);
        }
        return INSTANCE.setenv(name, value, overwrite);
    }

    public static int unsetEnv(String name) {
        if (Platform.isWindows()) {
            return INSTANCE._putenv(name + "=");
        }
        return INSTANCE.unsetenv(name);
    }

    public static int getProcessId() {
        return INSTANCE.getpid();
    }

    public int vsnprintf(ByteBuffer var1, int var2, String var3, Pointer var4);

    public int mlock(Pointer var1, NativeLong var2);

    public int munlock(Pointer var1, NativeLong var2);

    public int setenv(String var1, String var2, int var3);

    public int unsetenv(String var1);

    public int getpid();

    public int _putenv(String var1);
}

