/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.discovery;

import com.sun.jna.NativeLibrary;
import java.io.File;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.watermedia.videolan4j.VideoLan4J;
import org.watermedia.videolan4j.binding.internal.libvlc_instance_t;
import org.watermedia.videolan4j.discovery.Environment;
import org.watermedia.videolan4j.discovery.providers.IProvider;
import org.watermedia.videolan4j.tools.Tools;

public final class NativeDiscovery {
    private static final Marker IT = MarkerManager.getMarker((String)NativeDiscovery.class.getSimpleName());
    private static final ServiceLoader<IProvider> PROVIDERS = ServiceLoader.load(IProvider.class);
    private static Map<String, Reference<NativeLibrary>> jnaLibraries;
    private static Map<String, List<String>> jnaSearchPaths;
    private static boolean discovered;
    private static boolean attempted;
    private static String discoveredPath;

    public static boolean discovered() {
        return discovered;
    }

    public static String discoveryPath() {
        return discoveredPath;
    }

    public static synchronized boolean start() {
        if (discovered) {
            return true;
        }
        if (attempted) {
            return false;
        }
        Environment env = Environment.get();
        if (env == null) {
            VideoLan4J.LOGGER.info(IT, "Unsupported environment '{}'", (Object)Environment.osName());
            attempted = true;
            return false;
        }
        block0: for (IProvider provider : NativeDiscovery.getProviders()) {
            VideoLan4J.LOGGER.info(IT, "Searching using '{}'", (Object)provider.name());
            for (String d : provider.directories()) {
                String directory = NativeDiscovery.start$searchPath(env, d);
                if (directory == null) continue;
                if (NativeDiscovery.setSearchPath(env, directory)) {
                    VideoLan4J.LOGGER.info(IT, "Founded VLC binaries in '{}' using '{}', running test...", (Object)directory, (Object)provider.name());
                    if (NativeDiscovery.testInstance()) {
                        discoveredPath = directory;
                        discovered = true;
                        VideoLan4J.LOGGER.info(IT, "Successfully loaded VLC {} in '{}' using '{}'", (Object)VideoLan4J.getLibVersion(), (Object)directory, (Object)provider.name());
                        return true;
                    }
                    VideoLan4J.LOGGER.error(IT, "Failed to load VLC in '{}' using '{}'", (Object)directory, (Object)provider.name());
                    continue block0;
                }
                VideoLan4J.LOGGER.error(IT, "Failed to set search path for VLC in '{}' using '{}'", (Object)directory, (Object)provider.name());
                continue block0;
            }
        }
        attempted = true;
        return false;
    }

    private static String start$searchPath(Environment env, String directory) {
        File rootDirectory = new File(directory);
        File[] rootFiles = Tools.getRealFile(rootDirectory.toPath()).listFiles();
        if (rootFiles == null) {
            VideoLan4J.LOGGER.debug(IT, "Cannot search on path '{}', {}", (Object)directory, (Object)new DebugDirectory(rootDirectory));
            return null;
        }
        VideoLan4J.LOGGER.info(IT, "Searching on '{}'", (Object)rootDirectory.toString());
        Pattern[] patterns = env.getFilePatterns();
        HashSet<String> matches = new HashSet<String>(patterns.length);
        for (File child : rootFiles) {
            if (child.isDirectory()) {
                String r;
                if (!child.getName().toLowerCase().contains("vlc") && !child.getName().toLowerCase().contains("bin") && !child.getName().toLowerCase().contains("lib") || (r = NativeDiscovery.start$searchPath(env, child.getAbsolutePath())) == null) continue;
                return r;
            }
            for (Pattern pattern : patterns) {
                Matcher matcher = pattern.matcher(child.getName());
                if (!matcher.matches()) continue;
                matches.add(pattern.pattern());
                if (matches.size() != patterns.length) continue;
                return directory;
            }
        }
        matches.clear();
        return null;
    }

    private static boolean setSearchPath(Environment env, String path) {
        NativeLibrary.addSearchPath((String)VideoLan4J.LIBVLC_NAME, (String)path);
        NativeLibrary.addSearchPath((String)VideoLan4J.LIBVLCCORE_NAME, (String)path);
        boolean success = NativeDiscovery.setPluginPath(env, path);
        if (env == Environment.MACOS) {
            VideoLan4J.LOGGER.debug(IT, "Running on MACOS, preloading vlccore");
            NativeLibrary.getInstance((String)VideoLan4J.LIBVLCCORE_NAME);
        }
        return success;
    }

    private static boolean setPluginPath(Environment env, String path) {
        File f = new File(path);
        String[] pluginsPaths = env.getPluginPaths();
        if (pluginsPaths == null || pluginsPaths.length == 0) {
            VideoLan4J.LOGGER.error(IT, "No plugins paths defined for environment '{}'", (Object)env.name());
            return false;
        }
        for (String pluginsPath : pluginsPaths) {
            File p = f.toPath().resolve(pluginsPath).toAbsolutePath().toFile().getAbsoluteFile();
            if (p.exists() && p.isDirectory() && p.canRead() && p.canExecute()) {
                VideoLan4J.LOGGER.info(IT, "Setting plugins path to '{}'", (Object)p.toString());
                return env.setVar("VLC_PLUGIN_PATH", p.toString());
            }
            VideoLan4J.LOGGER.error(IT, "Plugins path '{}' doesn't exist or cannot be accessed, {}", (Object)p.toString(), (Object)new DebugDirectory(p));
        }
        VideoLan4J.LOGGER.error(IT, "Plugins path doesn't exist");
        return false;
    }

    private static boolean testInstance() {
        try {
            libvlc_instance_t instance = VideoLan4J.createInstance("--no-quiet", "--log-verbose=3", "--file-logging", "--logfile=" + new File("logs/videolan-discovery.log").getAbsolutePath(), "--verbose=2");
            if (instance == null) {
                VideoLan4J.LOGGER.error(IT, "Failed to create VLC test instance, printing log file");
                File logFile = new File("logs/videolan-discovery.log");
                if (logFile.exists() && logFile.canRead()) {
                    String logContent = Tools.readStringSafe(logFile.toPath());
                    if (logContent != null && !logContent.isEmpty()) {
                        String[] lines = logContent.split("\n");
                        VideoLan4J.LOGGER.error(IT, "VLC log file content START ------------");
                        for (String line : lines) {
                            VideoLan4J.LOGGER.error(IT, line);
                        }
                        VideoLan4J.LOGGER.error(IT, "VLC log file content END ------------");
                    } else {
                        VideoLan4J.LOGGER.error(IT, "VLC log file is empty or cannot be read, {}", (Object)new DebugDirectory(logFile));
                    }
                } else {
                    VideoLan4J.LOGGER.error(IT, "VLC log file doesn't exist or cannot be read, {}", (Object)new DebugDirectory(logFile));
                }
                VideoLan4J.LOGGER.error(IT, "VLC test instance is null, cannot continue discovery");
                return false;
            }
            VideoLan4J.releaseInstance(instance);
            if (VideoLan4J.isLibSupported()) {
                VideoLan4J.LOGGER.info(IT, "VLC test instance created successfully");
                return true;
            }
            VideoLan4J.LOGGER.error(IT, "VLC {} is not supported, supported versions are between {} and {}", (Object)VideoLan4J.getLibVersion(), (Object)VideoLan4J.LIBVLC_MIN_VERSION, (Object)VideoLan4J.LIBVLC_MAX_VERSION);
        }
        catch (Error e) {
            VideoLan4J.LOGGER.error(IT, "Failed to create and test VLC instance", (Throwable)e);
        }
        return false;
    }

    private static List<IProvider> getProviders() {
        Iterator<IProvider> i = PROVIDERS.iterator();
        ArrayList<IProvider> result = new ArrayList<IProvider>();
        while (i.hasNext()) {
            IProvider e = i.next();
            if (!e.supported()) continue;
            result.add(e);
        }
        result.sort(Comparator.comparing(IProvider::priority));
        return result;
    }

    static {
        discovered = false;
        attempted = false;
    }

    private static final class DebugDirectory {
        private final String path;
        private final boolean exists;
        private final boolean directory;
        private final boolean readable;
        private final boolean executable;
        private final boolean hidden;

        public DebugDirectory(File file) {
            this.path = file.toPath().toString();
            this.exists = file.exists();
            this.directory = file.isDirectory();
            this.readable = file.canRead();
            this.executable = file.canExecute();
            this.hidden = file.isHidden();
        }

        public String toString() {
            return "DebugDirectory{path='" + this.path + "', exists=" + this.exists + ", directory=" + this.directory + ", readable=" + this.readable + ", executable=" + this.executable + ", hidden=" + this.hidden + "}";
        }
    }
}

