/*
 * Decompiled with CFR 0.152.
 */
package org.omegaconfig;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.omegaconfig.ConfigSpec;
import org.omegaconfig.api.IConfigField;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class ConfigGroup
implements IConfigField<Void, Void> {
    public final String name;
    public final ConfigGroup group;
    Set<String> comments = new LinkedHashSet<String>();
    Set<IConfigField<?, ?>> fields = new LinkedHashSet();

    public ConfigGroup(String name, ConfigGroup group) {
        this.name = name;
        this.group = group;
        if (this.group != null) {
            this.group.append(this);
        }
    }

    public Collection<IConfigField<?, ?>> getFields() {
        return Collections.unmodifiableSet(this.fields);
    }

    public IConfigField<?, ?> getField(String id) {
        for (IConfigField<?, ?> field : this.fields) {
            if (field instanceof ConfigGroup) {
                ConfigGroup group = (ConfigGroup)field;
                return group.getField(id);
            }
            if (!field.id().equals(id)) continue;
            return field;
        }
        return null;
    }

    public IConfigField<?, ?> findField(String id) {
        String path;
        if (id == null || id.isEmpty()) {
            return null;
        }
        int specSeparator = id.indexOf(":");
        String specId = specSeparator != -1 ? id.substring(0, specSeparator) : null;
        String string = path = specSeparator != -1 ? id.substring(specSeparator + 1) : id;
        if (specId != null && !specId.equals(this.spec().id())) {
            return null;
        }
        String[] parts = path.split("\\.");
        ConfigGroup current = this;
        for (int i = 0; i < parts.length; ++i) {
            ConfigGroup group;
            String part = parts[i];
            boolean isLast = i == parts.length - 1;
            IConfigField<?, ?> field = null;
            for (IConfigField<?, ?> f : current.fields) {
                if (!f.name().equals(part)) continue;
                field = f;
                break;
            }
            if (field == null) {
                return null;
            }
            if (isLast) {
                return field;
            }
            if (!(field instanceof ConfigGroup)) {
                return null;
            }
            current = group = (ConfigGroup)field;
        }
        return null;
    }

    public void markDirty(IConfigField<?, ?> field) {
        this.spec().markDirty(field);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ConfigGroup group() {
        return this.group;
    }

    @Override
    public ConfigSpec spec() {
        ConfigSpec spec;
        ConfigGroup configGroup = this.group;
        return configGroup instanceof ConfigSpec ? (spec = (ConfigSpec)configGroup) : this.group.spec();
    }

    @Override
    public Class<Void> type() {
        throw new UnsupportedOperationException("Groups cannot handle types");
    }

    @Override
    public Class<Void> subType() {
        throw new UnsupportedOperationException("Groups cannot handle subTypes");
    }

    @Override
    public String[] comments() {
        return this.comments.toArray(new String[0]);
    }

    public <T extends IConfigField<?, ?>> void append(T field) {
        this.fields.add(field);
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException("Groups cannot handle values");
    }

    @Override
    public boolean reflected() {
        throw new UnsupportedOperationException("Groups cannot handle values");
    }

    @Override
    public void validate() {
        throw new UnsupportedOperationException("Groups cannot handle values");
    }

    @Override
    public void set0(Object object) {
        throw new UnsupportedOperationException("Groups cannot handle values");
    }

    @Override
    public void accept(Void unused) {
        throw new UnsupportedOperationException("Groups cannot handle values");
    }

    @Override
    public Void get() {
        throw new UnsupportedOperationException("Groups cannot give values");
    }
}

