/*
 * Decompiled with CFR 0.152.
 */
package org.omegaconfig;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.omegaconfig.ConfigSpec;
import org.omegaconfig.OmegaConfigRegistry;
import org.omegaconfig.Tools;
import org.omegaconfig.api.ICodec;
import org.omegaconfig.api.IComplexCodec;
import org.omegaconfig.api.annotations.Comment;
import org.omegaconfig.api.annotations.NumberConditions;
import org.omegaconfig.api.annotations.Spec;
import org.omegaconfig.api.annotations.StringConditions;

public class OmegaConfig {
    private static final Thread RT_WORKER = new Thread(OmegaConfig::run);
    public static final String ID = "omegaconfig";
    public static final String FORMAT_PROPERTIES = "properties";
    public static final String FORMAT_CFG = "cfg";
    public static final String FORMAT_JSON = "json";
    public static final String FORMAT_JSON5 = "json5";
    public static final String FORMAT_TOML = "toml";

    public static Path getPath() {
        return OmegaConfigRegistry.CONFIG_PATH;
    }

    public static void setPath(Path configPath) {
        OmegaConfigRegistry.CONFIG_PATH = configPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRegistered(String name) {
        Map<String, ConfigSpec> map = OmegaConfigRegistry.SPECS;
        synchronized (map) {
            return OmegaConfigRegistry.SPECS.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigSpec register(ConfigSpec spec) {
        Map<String, ConfigSpec> map = OmegaConfigRegistry.SPECS;
        synchronized (map) {
            OmegaConfigRegistry.SPECS.put(spec.name(), spec);
        }
        return spec;
    }

    public static ConfigSpec register(Class<?> clazz) {
        Objects.requireNonNull(clazz, "Spec class cannot be null");
        Spec spec = Tools.specOf(clazz);
        ConfigSpec.SpecBuilder builder = new ConfigSpec.SpecBuilder(spec.value(), OmegaConfigRegistry.FORMATS.get(spec.format()), spec.suffix(), spec.backups());
        OmegaConfig.register$iterateClass(clazz, clazz, builder, true);
        return OmegaConfig.register(builder.build());
    }

    public static ConfigSpec register(Object instance) {
        Objects.requireNonNull(instance, "Spec instance cannot be null");
        if (instance instanceof Class) {
            Class clazz = (Class)instance;
            return OmegaConfig.register(clazz);
        }
        Class<?> specClass = instance.getClass();
        Spec spec = Tools.specOf(specClass);
        ConfigSpec.SpecBuilder builder = new ConfigSpec.SpecBuilder(spec.value(), OmegaConfigRegistry.FORMATS.get(spec.format()), spec.suffix(), spec.backups());
        OmegaConfig.register$iterateClass(instance, specClass, builder, false);
        return OmegaConfig.register(builder.build());
    }

    private static void register$iterateClass(Object instance, Class<?> specClass, ConfigSpec.SpecBuilder builder, boolean isStatic) {
        for (Field field : specClass.getDeclaredFields()) {
            ConfigSpec.BaseFieldBuilder fieldBuilder;
            String name;
            if (isStatic != Modifier.isStatic(field.getModifiers())) continue;
            Spec.Field specField = Tools.specFieldOf(field);
            Class<?> specFieldClass = Tools.toBoxed(field.getType());
            if (specField == null) continue;
            String string = name = specField.value().isEmpty() ? field.getName() : specField.value();
            if (specFieldClass == Boolean.class) {
                fieldBuilder = builder.defineBoolean(name, field, instance);
            } else if (specFieldClass == Byte.class) {
                numberFieldBuilder = builder.defineByte(name, field, instance);
                conditions = field.getAnnotation(NumberConditions.class);
                if (conditions != null) {
                    numberFieldBuilder.math(conditions.math());
                    numberFieldBuilder.strictMath(conditions.strictMath());
                    numberFieldBuilder.setMin(conditions.minByte());
                    numberFieldBuilder.setMax(conditions.maxByte());
                }
                fieldBuilder = numberFieldBuilder;
            } else if (specFieldClass == Short.class) {
                numberFieldBuilder = builder.defineShort(name, field, instance);
                conditions = field.getAnnotation(NumberConditions.class);
                if (conditions != null) {
                    numberFieldBuilder.math(conditions.math());
                    numberFieldBuilder.strictMath(conditions.strictMath());
                    numberFieldBuilder.setMin(conditions.minShort());
                    numberFieldBuilder.setMax(conditions.maxShort());
                }
                fieldBuilder = numberFieldBuilder;
            } else if (specFieldClass == Integer.class) {
                numberFieldBuilder = builder.defineInt(name, field, instance);
                conditions = field.getAnnotation(NumberConditions.class);
                if (conditions != null) {
                    numberFieldBuilder.math(conditions.math());
                    numberFieldBuilder.strictMath(conditions.strictMath());
                    numberFieldBuilder.setMin(conditions.minInt());
                    numberFieldBuilder.setMax(conditions.maxInt());
                }
                fieldBuilder = numberFieldBuilder;
            } else if (specFieldClass == Long.class) {
                numberFieldBuilder = builder.defineLong(name, field, instance);
                conditions = field.getAnnotation(NumberConditions.class);
                if (conditions != null) {
                    numberFieldBuilder.math(conditions.math());
                    numberFieldBuilder.strictMath(conditions.strictMath());
                    numberFieldBuilder.setMin(conditions.minLong());
                    numberFieldBuilder.setMax(conditions.maxLong());
                }
                fieldBuilder = numberFieldBuilder;
            } else if (specFieldClass == Float.class) {
                numberFieldBuilder = builder.defineFloat(name, field, instance);
                conditions = field.getAnnotation(NumberConditions.class);
                if (conditions != null) {
                    numberFieldBuilder.math(conditions.math());
                    numberFieldBuilder.strictMath(conditions.strictMath());
                    numberFieldBuilder.setMin(Float.valueOf(conditions.minFloat()));
                    numberFieldBuilder.setMax(Float.valueOf(conditions.maxFloat()));
                }
                fieldBuilder = numberFieldBuilder;
            } else if (specFieldClass == Double.class) {
                numberFieldBuilder = builder.defineDouble(name, field, instance);
                conditions = field.getAnnotation(NumberConditions.class);
                if (conditions != null) {
                    numberFieldBuilder.math(conditions.math());
                    numberFieldBuilder.strictMath(conditions.strictMath());
                    numberFieldBuilder.setMin(conditions.minDouble());
                    numberFieldBuilder.setMax(conditions.maxDouble());
                }
                fieldBuilder = numberFieldBuilder;
            } else if (specFieldClass == String.class) {
                ConfigSpec.StringFieldBuilder stringFieldBuilder = builder.defineString(name, field, instance);
                conditions = field.getAnnotation(StringConditions.class);
                if (conditions != null) {
                    stringFieldBuilder.startsWith(conditions.startsWith());
                    stringFieldBuilder.endsWith(conditions.endsWith());
                    stringFieldBuilder.allowEmpty(conditions.allowEmpty());
                    stringFieldBuilder.condition(conditions.value());
                    stringFieldBuilder.regexFlags(conditions.regexFlags());
                    stringFieldBuilder.mode(conditions.mode());
                }
                fieldBuilder = stringFieldBuilder;
            } else {
                fieldBuilder = specFieldClass == Path.class ? builder.definePath(name, field, instance) : (specFieldClass == Character.class ? builder.defineChar(name, field, instance) : (specFieldClass == List.class ? builder.defineList(name, field, instance, Tools.subTypeOf(field)) : (specFieldClass.isArray() ? builder.defineArray(name, field, instance, Tools.subTypeOf(field)) : (Enum.class.isAssignableFrom(specFieldClass) ? builder.defineEnum(name, field, instance) : builder.define(name, field, instance)))));
            }
            Comment.Comments comments = field.getAnnotation(Comment.Comments.class);
            if (comments != null) {
                for (Comment comment : comments.value()) {
                    fieldBuilder.comments(comment.value());
                }
            }
            fieldBuilder.end();
        }
        for (AnnotatedElement annotatedElement : specClass.getDeclaredClasses()) {
            Spec spec = Tools.specOfWeak(annotatedElement);
            if (spec == null) continue;
            builder.push(spec.value());
            OmegaConfig.register$iterateClass(annotatedElement, annotatedElement, builder, isStatic);
            builder.pop();
        }
    }

    static String[] tryEncode(Object[] value, Class<?> type, Class<?> subType) {
        if (value instanceof String[]) {
            String[] s = (String[])value;
            return s;
        }
        ICodec<?> codec = OmegaConfigRegistry.CODECS.get(Tools.toBoxed(subType));
        if (codec == null) {
            for (ICodec<?> c : OmegaConfigRegistry.CODECS.values()) {
                if (!c.type().isAssignableFrom(subType)) continue;
                codec = c;
                break;
            }
        }
        if (codec == null) {
            throw new IllegalArgumentException("Codec for type '" + value.getClass().getName() + "' was not founded");
        }
        String[] result = new String[value.length];
        if (codec instanceof IComplexCodec) {
            IComplexCodec complexCodec = (IComplexCodec)codec;
            for (int i = 0; i < value.length; ++i) {
                result[i] = complexCodec.encode(value[i], subType);
            }
            return result;
        }
        for (int i = 0; i < value.length; ++i) {
            result[i] = codec.encode(value[i]);
        }
        return result;
    }

    static String tryEncode(Object value) {
        return OmegaConfig.tryEncode(value, null);
    }

    static String tryEncode(Object value, Class<?> subType) {
        if (value instanceof String) {
            String s = (String)value;
            return s;
        }
        ICodec<?> codec = OmegaConfigRegistry.CODECS.get(Tools.toBoxed(value.getClass()));
        if (codec == null) {
            for (ICodec<?> c : OmegaConfigRegistry.CODECS.values()) {
                if (c.type().isInstance(value)) {
                    codec = c;
                    break;
                }
                if (!c.type().isAssignableFrom(value.getClass())) continue;
                codec = c;
                break;
            }
        }
        if (codec == null) {
            throw new IllegalArgumentException("Codec for type '" + value.getClass().getName() + "' was not founded");
        }
        if (codec instanceof IComplexCodec) {
            IComplexCodec complexCodec = (IComplexCodec)codec;
            return complexCodec.encode(value, subType);
        }
        return codec.encode(value);
    }

    static <T, T2> T[] tryParse(String[] value, Class<T> type, Class<T2> subType) {
        if (value == null) {
            throw new NullPointerException("Value cannot be null");
        }
        if (subType == String.class) {
            return value;
        }
        ICodec<?> codec = OmegaConfigRegistry.CODECS.get(Tools.toBoxed(subType));
        if (codec == null) {
            for (ICodec<?> c : OmegaConfigRegistry.CODECS.values()) {
                if (!c.type().isAssignableFrom(subType)) continue;
                codec = c;
                break;
            }
        }
        if (codec == null) {
            throw new IllegalArgumentException("Codec for type '" + type.getName() + "' with subType '" + subType.getName() + "' was not founded");
        }
        if (codec instanceof IComplexCodec) {
            IComplexCodec complexCodec = (IComplexCodec)codec;
            Object[] result = (Object[])Array.newInstance(subType, value.length);
            for (int i = 0; i < value.length; ++i) {
                result[i] = complexCodec.decode(value[i], subType);
            }
            return result;
        }
        Object[] result = (Object[])Array.newInstance(subType, value.length);
        for (int i = 0; i < value.length; ++i) {
            result[i] = codec.decode(value[i]);
        }
        return result;
    }

    static <T, T2> T tryParse(String value, Class<T> type, Class<T2> type2) {
        if (type == String.class) {
            return (T)value;
        }
        ICodec<?> codec = OmegaConfigRegistry.CODECS.get(Tools.toBoxed(type));
        if (codec == null) {
            for (ICodec<?> c : OmegaConfigRegistry.CODECS.values()) {
                if (!c.type().isAssignableFrom(type)) continue;
                codec = c;
                break;
            }
        }
        if (codec == null) {
            throw new IllegalArgumentException("Codec for type '" + type.getName() + "' was not founded");
        }
        if (codec instanceof IComplexCodec) {
            IComplexCodec complexCodec = (IComplexCodec)codec;
            return complexCodec.decode(value, type2);
        }
        return (T)codec.decode(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void run() {
        while (!Thread.interrupted()) {
            Map<String, ConfigSpec> map = OmegaConfigRegistry.SPECS;
            synchronized (map) {
                for (ConfigSpec spec : OmegaConfigRegistry.SPECS.values()) {
                    try {
                        if (!spec.isLoaded() && !spec.load()) {
                            spec.save();
                        }
                        if (spec.isDirty()) {
                            spec.save();
                        }
                        if (!spec.isReload()) continue;
                        spec.load();
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Failed to process spec '" + spec.name() + "', spec flags=[loaded=" + spec.isLoaded() + ", dirty=" + spec.isDirty() + ", reload=" + spec.isReload() + "]", e);
                    }
                }
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        Thread.currentThread().interrupt();
    }

    public static void init() {
        OmegaConfigRegistry.init();
    }

    static {
        OmegaConfig.init();
        RT_WORKER.setDaemon(true);
        RT_WORKER.setName("OmegaConfig-Worker");
        RT_WORKER.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                RT_WORKER.interrupt();
                RT_WORKER.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }));
    }
}

