/*
 * Decompiled with CFR 0.152.
 */
package org.omegaconfig.impl.fields;

import java.lang.reflect.Field;
import java.util.Set;
import org.omegaconfig.ConfigGroup;
import org.omegaconfig.ConfigSpec;
import org.omegaconfig.Tools;
import org.omegaconfig.api.IConfigField;

public abstract class BaseConfigField<T, S>
implements IConfigField<T, S> {
    private final String name;
    private final ConfigGroup group;
    private final Mode mode;
    private final Set<String> comments;
    public final T defaultValue;
    private final Object context;
    private final Field field;
    private T value;

    protected BaseConfigField(String name, ConfigGroup group, Set<String> comments, Field field, Object context) {
        this.name = name;
        this.group = group;
        this.comments = comments;
        this.defaultValue = Tools.valueFrom(field, context);
        this.mode = Mode.REFLECT;
        this.field = field;
        this.context = context;
        this.group.append(this);
    }

    protected BaseConfigField(String name, ConfigGroup group, Set<String> comments, T defaultValue) {
        this.name = name;
        this.group = group;
        this.comments = comments;
        this.value = defaultValue;
        this.defaultValue = this.value;
        this.mode = Mode.NATIVE;
        this.field = null;
        this.context = null;
        this.group.append(this);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ConfigGroup group() {
        return this.group;
    }

    @Override
    public ConfigSpec spec() {
        ConfigSpec spec;
        ConfigGroup configGroup = this.group;
        return configGroup instanceof ConfigSpec ? (spec = (ConfigSpec)configGroup) : this.group.spec();
    }

    @Override
    public Class<S> subType() {
        return null;
    }

    @Override
    public String[] comments() {
        return this.comments.toArray(new String[0]);
    }

    @Override
    public void reset() {
        this.set(this.defaultValue);
    }

    @Override
    public T get() {
        return switch (this.mode) {
            default -> throw new IncompatibleClassChangeError();
            case Mode.REFLECT -> Tools.valueFrom(this.field, this.context);
            case Mode.NATIVE -> this.value;
            case Mode.ASM -> throw new UnsupportedOperationException("ASM not implemented yet");
        };
    }

    @Override
    public void accept(T t) {
        switch (this.mode) {
            case REFLECT: {
                Tools.setFieldValue(this.field, this.context, t);
                break;
            }
            case NATIVE: {
                this.value = t;
                break;
            }
            case ASM: {
                throw new UnsupportedOperationException("ASM not implemented yet");
            }
        }
        this.group.markDirty(this);
    }

    @Override
    public boolean reflected() {
        if (this.mode != Mode.REFLECT) {
            return true;
        }
        Object o = Tools.valueFrom(this.field, this.context);
        return this.value.equals(o);
    }

    private static enum Mode {
        REFLECT,
        NATIVE,
        ASM;

    }
}

