/*
 * Decompiled with CFR 0.152.
 */
package org.omegaconfig.impl.fields;

import java.lang.reflect.Field;
import java.util.Set;
import java.util.function.DoubleSupplier;
import org.omegaconfig.ConfigGroup;
import org.omegaconfig.impl.fields.BaseNumberField;

public final class FloatField
extends BaseNumberField<Float>
implements DoubleSupplier {
    public final float min;
    public final float max;
    private float primitive;

    public FloatField(String name, ConfigGroup group, Set<String> comments, boolean math, boolean strictMath, float min, float max, Field field, Object context) {
        super(name, group, comments, math, strictMath, field, context);
        this.primitive = ((Float)this.defaultValue).floatValue();
        this.min = min;
        this.max = max;
    }

    public FloatField(String name, ConfigGroup group, Set<String> comments, boolean math, boolean strictMath, float min, float max, Float defaultValue) {
        super(name, group, comments, math, strictMath, defaultValue);
        this.primitive = ((Float)this.defaultValue).floatValue();
        this.min = min;
        this.max = max;
    }

    @Override
    public Class<Float> type() {
        return Float.class;
    }

    @Override
    public void validate() {
        if (this.primitive < this.min || this.primitive > this.max) {
            this.reset();
        }
    }

    @Override
    public void accept(Float value) {
        this.primitive = value.floatValue();
        super.accept(Float.valueOf(this.primitive));
    }

    @Override
    public double getAsDouble() {
        return this.primitive;
    }

    public double getAsFloat() {
        return this.primitive;
    }

    @Override
    public String minValueString() {
        return this.min == Float.MIN_VALUE ? null : String.valueOf(this.min);
    }

    @Override
    public String maxValueString() {
        return this.max == Float.MAX_VALUE ? null : String.valueOf(this.max);
    }
}

