/*
 * Decompiled with CFR 0.152.
 */
package org.omegaconfig.impl.fields;

import java.lang.reflect.Field;
import java.util.Set;
import java.util.function.IntSupplier;
import org.omegaconfig.ConfigGroup;
import org.omegaconfig.impl.fields.BaseNumberField;

public final class IntField
extends BaseNumberField<Integer>
implements IntSupplier {
    public final int min;
    public final int max;
    private int primitive;

    public IntField(String name, ConfigGroup group, Set<String> comments, boolean math, boolean strictMath, int min, int max, Field field, Object context) {
        super(name, group, comments, math, strictMath, field, context);
        this.primitive = (Integer)this.defaultValue;
        this.min = min;
        this.max = max;
    }

    public IntField(String name, ConfigGroup group, Set<String> comments, boolean math, boolean strictMath, int min, int max, Integer defaultValue) {
        super(name, group, comments, math, strictMath, defaultValue);
        this.primitive = (Integer)this.defaultValue;
        this.min = min;
        this.max = max;
    }

    @Override
    public Class<Integer> type() {
        return Integer.class;
    }

    @Override
    public void validate() {
        if (this.primitive < this.min || this.primitive > this.max) {
            this.reset();
        }
    }

    @Override
    public void accept(Integer integer) {
        this.primitive = integer;
        super.accept(this.primitive);
    }

    @Override
    public int getAsInt() {
        return this.primitive;
    }

    @Override
    public String maxValueString() {
        return this.max == Integer.MAX_VALUE ? null : String.valueOf(this.max);
    }

    @Override
    public String minValueString() {
        return this.min == Integer.MIN_VALUE ? null : String.valueOf(this.min);
    }
}

