/*
 * Decompiled with CFR 0.152.
 */
package org.omegaconfig.impl.fields;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.omegaconfig.ConfigGroup;
import org.omegaconfig.impl.fields.CollectionField;

public final class ListField<T>
extends CollectionField<List<T>, T> {
    public ListField(String name, ConfigGroup group, Set<String> comments, boolean stringify, boolean singleline, boolean allowEmpty, boolean unique, int limit, Class<? extends Predicate<T>> filter, Field field, Object context, Class<T> subType) {
        super(name, group, comments, stringify, singleline, allowEmpty, unique, limit, filter, field, context, subType);
    }

    public ListField(String name, ConfigGroup group, Set<String> comments, boolean stringify, boolean singleline, boolean allowEmpty, boolean unique, int limit, Class<? extends Predicate<T>> filter, List<T> defaultValue, Class<T> subType) {
        super(name, group, comments, stringify, singleline, allowEmpty, unique, limit, filter, defaultValue, subType);
    }

    @Override
    public CollectionField<List<T>, T> setArray(Object[] array) {
        ArrayList fresh = new ArrayList();
        for (Object obj : array) {
            if (!this.subType.isInstance(obj)) {
                throw new IllegalArgumentException("Array contains elements not of type " + this.subType.getName());
            }
            fresh.add(this.subType.cast(obj));
        }
        this.set(fresh);
        return this;
    }

    @Override
    public void validate() {
        if (this.get().isEmpty() && !this.allowEmpty) {
            this.reset();
            return;
        }
        if (this.unique && (long)this.get().size() != this.get().stream().distinct().count()) {
            this.set((List)this.get().stream().distinct().collect(Collectors.toCollection(ArrayList::new)));
            return;
        }
        if (this.limit > 0 && this.get().size() > this.limit) {
            this.set((List)this.get().stream().distinct().limit(this.limit).collect(Collectors.toCollection(ArrayList::new)));
        }
    }

    @Override
    public Class<List<T>> type() {
        return List.class;
    }

    @Override
    public List<T> get() {
        return Collections.unmodifiableList((List)super.get());
    }

    public ListField<T> add(T element) {
        if (element == null) {
            return this;
        }
        List current = (List)super.get();
        try {
            current.add(element);
        }
        catch (Exception e) {
            ArrayList<T> list = new ArrayList<T>(current);
            list.add(element);
            this.set(list);
        }
        return this;
    }

    public ListField<T> remove(T element) {
        if (element == null) {
            return this;
        }
        List current = (List)super.get();
        if (current.isEmpty()) {
            return this;
        }
        try {
            current.remove(element);
        }
        catch (Exception e) {
            ArrayList list = new ArrayList(current);
            list.remove(element);
            this.set(list);
        }
        return this;
    }

    @Override
    public T remove(int index) {
        List current = (List)super.get();
        try {
            return (T)current.remove(index);
        }
        catch (Exception e) {
            ArrayList list = new ArrayList(current);
            Object value = list.remove(index);
            this.set(list);
            return (T)value;
        }
    }

    @Override
    public boolean contains(T element) {
        return this.get().contains(element);
    }

    @Override
    public int size() {
        return this.get().size();
    }

    public ListField<T> clear() {
        this.set(new ArrayList());
        return this;
    }
}

