/*
 * Decompiled with CFR 0.152.
 */
package org.omegaconfig.impl.fields;

import java.lang.reflect.Field;
import java.util.Set;
import java.util.function.IntSupplier;
import org.omegaconfig.ConfigGroup;
import org.omegaconfig.impl.fields.BaseNumberField;

public final class ShortField
extends BaseNumberField<Short>
implements IntSupplier {
    public final short min;
    public final short max;
    private short primitive;

    public ShortField(String name, ConfigGroup group, Set<String> comments, boolean math, boolean strictMath, short min, short max, Field field, Object context) {
        super(name, group, comments, math, strictMath, field, context);
        this.primitive = (Short)this.defaultValue;
        this.min = min;
        this.max = max;
    }

    public ShortField(String name, ConfigGroup group, Set<String> comments, boolean math, boolean strictMath, short min, short max, Short defaultValue) {
        super(name, group, comments, math, strictMath, defaultValue);
        this.primitive = (Short)this.defaultValue;
        this.min = min;
        this.max = max;
    }

    @Override
    public Class<Short> type() {
        return Short.class;
    }

    @Override
    public void validate() {
        if (this.primitive < this.min || this.primitive > this.max) {
            this.reset();
        }
    }

    @Override
    public void accept(Short value) {
        this.primitive = value;
        super.accept(this.primitive);
    }

    @Override
    public int getAsInt() {
        return this.primitive;
    }

    public short getAsShort() {
        return this.primitive;
    }

    @Override
    public String minValueString() {
        return this.min == Short.MIN_VALUE ? null : String.valueOf(this.min);
    }

    @Override
    public String maxValueString() {
        return this.max == Short.MAX_VALUE ? null : String.valueOf(this.max);
    }
}

