/*
 * Decompiled with CFR 0.152.
 */
package org.omegaconfig.impl.fields;

import java.lang.reflect.Field;
import java.util.Set;
import java.util.regex.Pattern;
import org.omegaconfig.ConfigGroup;
import org.omegaconfig.impl.fields.BaseConfigField;

public final class StringField
extends BaseConfigField<String, Void> {
    public final String startsWith;
    public final String endsWith;
    public final String condition;
    public final boolean allowEmpty;
    public final int regexFlags;
    public final Mode mode;

    public StringField(String name, ConfigGroup group, Set<String> comments, String startsWith, String endsWith, boolean allowEmpty, String condition, int regexFlags, Mode mode, Field field, Object context) {
        super(name, group, comments, field, context);
        this.startsWith = startsWith;
        this.endsWith = endsWith;
        this.allowEmpty = allowEmpty;
        this.condition = condition;
        this.regexFlags = regexFlags;
        this.mode = mode;
    }

    public StringField(String name, ConfigGroup group, Set<String> comments, String startsWith, String endsWith, boolean allowEmpty, String condition, int regexFlags, Mode mode, String defaultValue) {
        super(name, group, comments, defaultValue);
        this.startsWith = startsWith;
        this.endsWith = endsWith;
        this.allowEmpty = allowEmpty;
        this.condition = condition;
        this.regexFlags = regexFlags;
        this.mode = mode;
    }

    @Override
    public void validate() {
        String value = (String)this.get();
        if (value.isEmpty() && !this.allowEmpty) {
            this.reset();
            return;
        }
        if (this.startsWith != null && !value.startsWith(this.startsWith)) {
            this.reset();
            return;
        }
        if (this.endsWith != null && !value.endsWith(this.endsWith)) {
            this.reset();
            return;
        }
        if (this.condition != null && !this.condition.isEmpty()) {
            boolean conditionCheck;
            switch (this.mode) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case CONTAINS: {
                    boolean bl = value.contains(this.condition);
                    break;
                }
                case EQUALS: {
                    boolean bl = value.equals(this.condition);
                    break;
                }
                case REGEX: {
                    boolean bl = Pattern.compile(this.condition, this.regexFlags).matcher(value).matches();
                    break;
                }
                case NOT_CONTAINS: {
                    boolean bl;
                    if (!value.contains(this.condition)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case NOT_EQUALS: {
                    boolean bl;
                    if (!value.equals(this.condition)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case NOT_REGEX: {
                    boolean bl = conditionCheck = !value.matches(this.condition);
                }
            }
            if (!conditionCheck) {
                this.reset();
            }
        }
    }

    @Override
    public Class<String> type() {
        return String.class;
    }

    public static enum Mode {
        CONTAINS,
        EQUALS,
        REGEX,
        NOT_CONTAINS,
        NOT_EQUALS,
        NOT_REGEX;

    }
}

