/*
 * Decompiled with CFR 0.152.
 */
package org.omegaconfig.impl.formats;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.omegaconfig.Tools;
import org.omegaconfig.api.formats.IFormatCodec;
import org.omegaconfig.api.formats.IFormatReader;
import org.omegaconfig.api.formats.IFormatWriter;

public class CFGFormat
implements IFormatCodec {
    @Override
    public String id() {
        return "cfg";
    }

    @Override
    public String extension() {
        return "." + this.id();
    }

    @Override
    public String mimeType() {
        return "text/x-cfg";
    }

    @Override
    public IFormatReader createReader(Path filePath) throws IOException {
        return new FormatReader(filePath);
    }

    @Override
    public IFormatWriter createWritter(Path filePath) throws IOException {
        return new FormatWriter(filePath);
    }

    public static class FormatReader
    implements IFormatReader {
        private final LinkedHashMap<String, Object> values = new LinkedHashMap();
        private final Stack<String> group = new Stack();
        private final Map<String, Object> rawParsedData = new LinkedHashMap<String, Object>();

        public FormatReader(Path path) throws IOException {
            char[] data = new String(Tools.readAllBytes(path), StandardCharsets.UTF_8).toCharArray();
            this.parseCfg(data);
        }

        private void parseCfg(char[] data) throws IOException {
            int i = this.skipWhitespaceAndComments(data, 0, data.length);
            if (i >= data.length || data[i] != '{') {
                throw new IOException("CFG file must start with '{'");
            }
            this.parseMapping(data, ++i, data.length, "");
        }

        private int parseMapping(char[] data, int start, int len, String prefix) throws IOException {
            int i = start;
            boolean firstEntry = true;
            while (i < len && (i = this.skipWhitespaceAndComments(data, i, len)) < len) {
                if (data[i] == '}') {
                    return i + 1;
                }
                if (!(firstEntry || data[i] != ',' && data[i] != '\n')) {
                    ++i;
                    if ((i = this.skipWhitespaceAndComments(data, i, len)) >= len) break;
                    if (data[i] == '}') {
                        return i + 1;
                    }
                }
                firstEntry = false;
                StringBuilder key = new StringBuilder();
                i = this.parseKey(data, i, len, key);
                if ((i = this.skipWhitespaceAndComments(data, i, len)) >= len || data[i] != ':' && data[i] != '=') {
                    throw new IOException("Expected ':' or '=' after key at position " + i);
                }
                ++i;
                i = this.skipWhitespaceAndComments(data, i, len);
                String fullKey = prefix.isEmpty() ? key.toString() : prefix + "." + key.toString();
                i = this.parseValue(data, i, len, fullKey);
            }
            return i;
        }

        private int parseKey(char[] data, int start, int len, StringBuilder key) throws IOException {
            int i = start;
            char c = data[i];
            if (c == '\"' || c == '\'') {
                char quote = c;
                ++i;
                while (i < len && data[i] != quote) {
                    if (data[i] == '\\' && i + 1 < len) {
                        key.append(this.unescapeChar(data[++i]));
                    } else {
                        key.append(data[i]);
                    }
                    ++i;
                }
                if (i >= len) {
                    throw new IOException("Unclosed quoted key");
                }
                ++i;
            } else {
                if (!Character.isLetter(c) && c != '_') {
                    throw new IOException("Invalid key start character at position " + i);
                }
                while (i < len && (Character.isLetterOrDigit(data[i]) || data[i] == '_')) {
                    key.append(data[i]);
                    ++i;
                }
            }
            return i;
        }

        private int parseValue(char[] data, int start, int len, String key) throws IOException {
            int i = start;
            if (i >= len) {
                throw new IOException("Expected value after separator at position " + i);
            }
            char c = data[i];
            if (c == '\"' || c == '\'') {
                return this.parseString(data, i, len, key);
            }
            if (c == '[') {
                return this.parseArray(data, i, len, key);
            }
            if (c == '{') {
                return this.parseMapping(data, ++i, len, key);
            }
            if (c == '$' && i + 1 < len && data[i + 1] == '{') {
                return this.parseReference(data, i, len, key);
            }
            if (c == '@') {
                return this.parseInclude(data, i, len, key);
            }
            if (c == '`') {
                return this.parseSpecialValue(data, i, len, key);
            }
            return this.parseLiteral(data, i, len, key);
        }

        private int parseString(char[] data, int start, int len, String key) throws IOException {
            int i = start;
            char quote = data[i];
            ++i;
            StringBuilder value = new StringBuilder();
            while (i < len && data[i] != quote) {
                if (data[i] == '\\' && i + 1 < len) {
                    value.append(this.unescapeChar(data[++i]));
                } else {
                    value.append(data[i]);
                }
                ++i;
            }
            if (i >= len) {
                throw new IOException("Unclosed string at position " + i);
            }
            this.values.put(key, value.toString());
            return ++i;
        }

        private int parseArray(char[] data, int start, int len, String key) throws IOException {
            int i = start + 1;
            ArrayList<String> array = new ArrayList<String>();
            boolean firstElement = true;
            while (i < len) {
                if ((i = this.skipWhitespaceAndComments(data, i, len)) >= len) {
                    throw new IOException("Unclosed array");
                }
                if (data[i] == ']') {
                    this.values.put(key, array.toArray(new String[0]));
                    return ++i;
                }
                if (!(firstElement || data[i] != ',' && data[i] != '\n')) {
                    ++i;
                    if ((i = this.skipWhitespaceAndComments(data, i, len)) >= len) break;
                    if (data[i] == ']') {
                        this.values.put(key, array.toArray(new String[0]));
                        return ++i;
                    }
                }
                firstElement = false;
                StringBuilder element = new StringBuilder();
                i = this.parseArrayElement(data, i, len, element);
                array.add(element.toString());
            }
            throw new IOException("Unclosed array");
        }

        private int parseArrayElement(char[] data, int start, int len, StringBuilder element) throws IOException {
            int i = start;
            char c = data[i];
            if (c == '\"' || c == '\'') {
                char quote = c;
                ++i;
                while (i < len && data[i] != quote) {
                    if (data[i] == '\\' && i + 1 < len) {
                        element.append(this.unescapeChar(data[++i]));
                    } else {
                        element.append(data[i]);
                    }
                    ++i;
                }
                if (i >= len) {
                    throw new IOException("Unclosed string in array");
                }
                return ++i;
            }
            while (i < len && !Character.isWhitespace(data[i]) && data[i] != ',' && data[i] != ']' && data[i] != '#') {
                element.append(data[i]);
                ++i;
            }
            return i;
        }

        private int parseLiteral(char[] data, int start, int len, String key) throws IOException {
            int i;
            StringBuilder value = new StringBuilder();
            for (i = start; i < len && !Character.isWhitespace(data[i]) && data[i] != ',' && data[i] != '}' && data[i] != ']' && data[i] != '#'; ++i) {
                value.append(data[i]);
            }
            String literal = value.toString().trim();
            this.values.put(key, literal);
            return i;
        }

        private int parseReference(char[] data, int start, int len, String key) throws IOException {
            int i;
            StringBuilder ref = new StringBuilder("${");
            for (i = start + 2; i < len && data[i] != '}'; ++i) {
                ref.append(data[i]);
            }
            if (i >= len) {
                throw new IOException("Unclosed reference");
            }
            ref.append('}');
            this.values.put(key, ref.toString());
            return ++i;
        }

        private int parseInclude(char[] data, int start, int len, String key) throws IOException {
            int i = start + 1;
            if ((i = this.skipWhitespaceAndComments(data, i, len)) >= len || data[i] != '\"' && data[i] != '\'') {
                throw new IOException("Expected quoted filename after @ at position " + i);
            }
            char quote = data[i];
            ++i;
            StringBuilder filename = new StringBuilder("@");
            filename.append(quote);
            while (i < len && data[i] != quote) {
                filename.append(data[i]);
                ++i;
            }
            if (i >= len) {
                throw new IOException("Unclosed include filename");
            }
            filename.append(quote);
            this.values.put(key, filename.toString());
            return ++i;
        }

        private int parseSpecialValue(char[] data, int start, int len, String key) throws IOException {
            int i;
            StringBuilder special = new StringBuilder("`");
            for (i = start + 1; i < len && data[i] != '`'; ++i) {
                special.append(data[i]);
            }
            if (i >= len) {
                throw new IOException("Unclosed special value");
            }
            special.append('`');
            this.values.put(key, special.toString());
            return ++i;
        }

        private int skipWhitespaceAndComments(char[] data, int start, int len) {
            int i = start;
            while (i < len) {
                if (Character.isWhitespace(data[i])) {
                    ++i;
                    continue;
                }
                if (data[i] != '#') break;
                i = this.skipToEndOfLine(data, i, len);
            }
            return i;
        }

        private int skipToEndOfLine(char[] data, int start, int len) {
            int i;
            for (i = start; i < len && data[i] != '\n'; ++i) {
            }
            if (i < len && data[i] == '\n') {
                ++i;
            }
            return i;
        }

        private char unescapeChar(char c) {
            return switch (c) {
                case 'n' -> '\n';
                case 'r' -> '\r';
                case 't' -> '\t';
                case 'b' -> '\b';
                case 'f' -> '\f';
                case '\\' -> '\\';
                case '\"' -> '\"';
                case '\'' -> '\'';
                default -> c;
            };
        }

        @Override
        public String read(String fieldName) {
            String key = Tools.concat("", (!this.group.isEmpty() ? "." : "") + fieldName, '.', this.group);
            Object value = this.values.get(key);
            if (value instanceof String) {
                String s = (String)value;
                return s;
            }
            return null;
        }

        @Override
        public String[] readArray(String fieldName) {
            String key = Tools.concat("", (!this.group.isEmpty() ? "." : "") + fieldName, '.', this.group);
            Object value = this.values.get(key);
            if (value instanceof String[]) {
                String[] s = (String[])value;
                return s;
            }
            return null;
        }

        @Override
        public void push(String group) {
            this.group.push(group);
        }

        @Override
        public void pop() {
            if (!this.group.isEmpty()) {
                this.group.pop();
            }
        }

        @Override
        public void close() {
            this.values.clear();
            this.group.clear();
        }
    }

    public static class FormatWriter
    implements IFormatWriter {
        private final Stack<String> group = new Stack();
        private final BufferedWriter writer;
        private final StringBuilder buffer = new StringBuilder();
        private final List<String> comments = new ArrayList<String>();
        private boolean firstInMapping = true;
        private int indentLevel = 0;

        public FormatWriter(Path path) throws IOException {
            if (!path.toFile().getParentFile().exists() && !path.toFile().getParentFile().mkdirs()) {
                throw new IOException("Failed to create parent directories for " + path);
            }
            this.writer = new BufferedWriter(new FileWriter(path.toFile(), StandardCharsets.UTF_8));
            this.buffer.append("{\n");
            this.indentLevel = 1;
        }

        @Override
        public void write(String comment) {
            this.comments.add(comment);
        }

        @Override
        public void write(String fieldName, String value, Class<?> type, Class<?> subType) {
            if (!this.firstInMapping && !this.comments.isEmpty()) {
                this.buffer.append("\n");
            }
            this.writeComments();
            this.indent();
            this.buffer.append(this.formatKey(fieldName)).append(": ");
            this.buffer.append(this.formatValue(value, type));
            this.buffer.append("\n");
            this.firstInMapping = false;
        }

        @Override
        public void write(String fieldName, String[] values, Class<?> type, Class<?> subType) {
            if (!this.firstInMapping && !this.comments.isEmpty()) {
                this.buffer.append("\n");
            }
            this.writeComments();
            this.indent();
            this.buffer.append(this.formatKey(fieldName)).append(": ");
            this.buffer.append("[");
            if (values.length > 0) {
                this.buffer.append("\n");
                for (int i = 0; i < values.length; ++i) {
                    this.indent();
                    this.buffer.append("  ").append(this.formatValue(values[i], subType));
                    if (i < values.length - 1) {
                        this.buffer.append(",");
                    }
                    this.buffer.append("\n");
                }
                this.indent();
            }
            this.buffer.append("]");
            this.buffer.append("\n");
            this.firstInMapping = false;
        }

        @Override
        public void push(String groupName) {
            if (!this.firstInMapping && !this.comments.isEmpty()) {
                this.buffer.append("\n");
            }
            this.writeComments();
            this.indent();
            this.buffer.append(this.formatKey(groupName)).append(": {\n");
            this.group.push(groupName);
            ++this.indentLevel;
            this.firstInMapping = true;
        }

        @Override
        public void pop() {
            if (!this.group.isEmpty()) {
                this.group.pop();
                --this.indentLevel;
                this.buffer.append("\n");
                this.indent();
                this.buffer.append("}");
                this.firstInMapping = false;
            }
        }

        @Override
        public void close() throws IOException {
            this.buffer.append("\n}\n");
            this.writer.write(this.buffer.toString());
            this.writer.flush();
            this.writer.close();
        }

        private void writeComments() {
            for (String comment : this.comments) {
                this.indent();
                this.buffer.append("# ").append(comment).append("\n");
            }
            this.comments.clear();
        }

        private void indent() {
            this.buffer.append("  ".repeat(this.indentLevel));
        }

        private String formatKey(String key) {
            if (key.matches("[A-Za-z_][A-Za-z0-9_]*")) {
                return key;
            }
            return "\"" + this.escapeString(key) + "\"";
        }

        private String formatValue(String value, Class<?> type) {
            if (type == null) {
                return "\"" + this.escapeString(value) + "\"";
            }
            if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) {
                return value.toLowerCase();
            }
            if (value == null || value.equals("null")) {
                return "null";
            }
            if (Number.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type) || Byte.TYPE.isAssignableFrom(type) || Short.TYPE.isAssignableFrom(type)) {
                return value;
            }
            return "\"" + this.escapeString(value) + "\"";
        }

        private String escapeString(String str) {
            return str.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t").replace("\b", "\\b").replace("\f", "\\f");
        }
    }
}

