/*
 * Decompiled with CFR 0.152.
 */
package org.omegaconfig.impl.formats;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Stack;
import org.omegaconfig.Tools;
import org.omegaconfig.api.formats.IFormatCodec;
import org.omegaconfig.api.formats.IFormatReader;
import org.omegaconfig.api.formats.IFormatWriter;

public class PROPFormat
implements IFormatCodec {
    public static final String FORMAT_KEY_DEF_SPLIT = "=";
    public static final String FORMAT_KEY_BREAKLINE = "\n";
    public static final String FORMAT_KEY_COMMENT_LINE = "#";
    public static final char FORMAT_KEY_GROUP_SPLIT = '.';

    @Override
    public String id() {
        return "properties";
    }

    @Override
    public String extension() {
        return "." + this.id();
    }

    @Override
    public String mimeType() {
        return "text/x-java-properties";
    }

    @Override
    public IFormatReader createReader(Path filePath) throws IOException {
        return new FormatReader(filePath);
    }

    @Override
    public IFormatWriter createWritter(Path filePath) throws IOException {
        return new FormatWriter(filePath);
    }

    private static class FormatReader
    implements IFormatReader {
        private final LinkedHashMap<String, String> fields = new LinkedHashMap();
        private final Stack<String> groups = new Stack();

        public FormatReader(Path filePath) throws IOException {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(filePath.toFile()));
            while ((line = in.readLine()) != null) {
                String[] parts;
                if ((line = line.trim()).isEmpty() || line.startsWith(PROPFormat.FORMAT_KEY_COMMENT_LINE) || (parts = line.split(PROPFormat.FORMAT_KEY_DEF_SPLIT, 2)).length != 2) continue;
                String key = parts[0].trim();
                String value = parts[1].trim();
                this.fields.put(key, value);
            }
            in.close();
        }

        @Override
        public String read(String fieldName) {
            StringBuilder group = new StringBuilder();
            for (String g : this.groups) {
                group.append(g).append('.');
            }
            return this.fields.get(group.append(fieldName).toString());
        }

        @Override
        public String[] readArray(String fieldName) {
            StringBuilder group = new StringBuilder();
            for (String g : this.groups) {
                group.append(g).append('.');
            }
            String value = this.fields.get(group.append(fieldName).toString());
            if (value.charAt(0) == '[' && value.charAt(value.length() - 1) == ']') {
                value = value.substring(1, value.length() - 1);
                return value.trim().split(",");
            }
            return null;
        }

        @Override
        public void push(String group) {
            this.groups.push(group);
        }

        @Override
        public void pop() {
            this.groups.pop();
        }

        @Override
        public void close() {
            this.fields.clear();
        }
    }

    private static class FormatWriter
    implements IFormatWriter {
        private final Stack<String> groups = new Stack();
        private final BufferedWriter out;
        private final StringBuilder data = new StringBuilder();

        public FormatWriter(Path filePath) throws IOException {
            this.out = new BufferedWriter(new FileWriter(filePath.toFile()));
        }

        @Override
        public void write(String comment) {
            this.data.append("# ").append(comment).append(PROPFormat.FORMAT_KEY_BREAKLINE);
        }

        @Override
        public void write(String fieldName, String value, Class<?> type, Class<?> subType) {
            this.data.append(Tools.concat("", "", '.', this.groups)).append((String)(this.groups.isEmpty() ? fieldName : "." + fieldName)).append(PROPFormat.FORMAT_KEY_DEF_SPLIT).append(value).append(PROPFormat.FORMAT_KEY_BREAKLINE);
        }

        @Override
        public void write(String fieldName, String[] values, Class<?> type, Class<?> subType) {
            String arrayString = "[" + String.join((CharSequence)", ", values) + "]";
            this.data.append(Tools.concat("", "", '.', this.groups)).append((String)(this.groups.isEmpty() ? fieldName : "." + fieldName)).append(PROPFormat.FORMAT_KEY_DEF_SPLIT).append(arrayString).append(PROPFormat.FORMAT_KEY_BREAKLINE);
        }

        @Override
        public void push(String groupName) {
            this.groups.push(groupName);
            this.data.append(PROPFormat.FORMAT_KEY_BREAKLINE);
            this.write("Begin of group " + Tools.concat("", "", '.', this.groups));
        }

        @Override
        public void pop() {
            this.groups.pop();
            this.data.append(PROPFormat.FORMAT_KEY_BREAKLINE.repeat(2));
        }

        @Override
        public void close() throws IOException {
            String data = this.data.toString();
            if (data.endsWith(PROPFormat.FORMAT_KEY_BREAKLINE.repeat(2))) {
                data = data.substring(0, data.length() - PROPFormat.FORMAT_KEY_BREAKLINE.length() * 2);
            }
            this.out.write(data);
            this.out.close();
        }
    }
}

