/*
 * Decompiled with CFR 0.152.
 */
package org.omegaconfig.impl.formats;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import org.omegaconfig.Tools;
import org.omegaconfig.api.formats.IFormatCodec;
import org.omegaconfig.api.formats.IFormatReader;
import org.omegaconfig.api.formats.IFormatWriter;

public class TOMLFormat
implements IFormatCodec {
    @Override
    public String id() {
        return "toml";
    }

    @Override
    public String extension() {
        return "." + this.id();
    }

    @Override
    public String mimeType() {
        return "text/toml";
    }

    @Override
    public IFormatReader createReader(Path filePath) throws IOException {
        return new FormatReader(filePath);
    }

    @Override
    public IFormatWriter createWritter(Path filePath) throws IOException {
        return new FormatWriter(filePath);
    }

    public static class FormatReader
    implements IFormatReader {
        private final LinkedHashMap<String, Object> values = new LinkedHashMap();
        private final Stack<String> group = new Stack();
        private String currentTable = "";

        public FormatReader(Path path) throws IOException {
            char[] data = new String(Tools.readAllBytes(path), StandardCharsets.UTF_8).toCharArray();
            this.parseToml(data);
        }

        private void parseToml(char[] data) throws IOException {
            int i = 0;
            int len = data.length;
            while (i < len) {
                char c = data[i];
                if (Character.isWhitespace(c)) {
                    ++i;
                    continue;
                }
                if (c == '#') {
                    i = this.skipToEndOfLine(data, i);
                    continue;
                }
                if (c == '[') {
                    i = this.parseTableHeader(data, i);
                    continue;
                }
                if (this.isKeyStart(c)) {
                    i = this.parseKeyValue(data, i);
                    continue;
                }
                ++i;
            }
        }

        private int parseTableHeader(char[] data, int start) throws IOException {
            int i = start + 1;
            int len = data.length;
            boolean isArray = false;
            if (i < len && data[i] == '[') {
                isArray = true;
                ++i;
            }
            while (i < len && Character.isWhitespace(data[i])) {
                ++i;
            }
            StringBuilder tableName = new StringBuilder();
            while (i < len && data[i] != ']') {
                if (data[i] == '#') {
                    throw new IOException("Comment not allowed in table header");
                }
                tableName.append(data[i]);
                ++i;
            }
            if (i >= len) {
                throw new IOException("Unclosed table header");
            }
            ++i;
            if (isArray) {
                if (i >= len || data[i] != ']') {
                    throw new IOException("Expected ]] for array of tables");
                }
                ++i;
            }
            this.currentTable = tableName.toString().trim();
            return this.skipToEndOfLine(data, i);
        }

        private int parseKeyValue(char[] data, int start) throws IOException {
            int i = start;
            int len = data.length;
            StringBuilder key = new StringBuilder();
            for (i = this.parseKey(data, i, key); i < len && Character.isWhitespace(data[i]); ++i) {
            }
            if (i >= len || data[i] != '=') {
                throw new IOException("Expected '=' after key");
            }
            while (++i < len && Character.isWhitespace(data[i])) {
            }
            String fullKey = this.buildFullKey(key.toString());
            i = this.parseValue(data, i, fullKey);
            return i;
        }

        private int parseKey(char[] data, int start, StringBuilder key) throws IOException {
            int i;
            int len = data.length;
            char c = data[i];
            if (c == '\"' || c == '\'') {
                char quote = c;
                ++i;
                while (i < len && data[i] != quote) {
                    if (data[i] == '\\' && i + 1 < len) {
                        key.append(this.unescapeChar(data[++i]));
                    } else {
                        key.append(data[i]);
                    }
                    ++i;
                }
                if (i >= len) {
                    throw new IOException("Unclosed quoted key");
                }
                ++i;
            } else {
                for (i = start; i < len && (Character.isLetterOrDigit(data[i]) || data[i] == '_' || data[i] == '-'); ++i) {
                    key.append(data[i]);
                }
            }
            return i;
        }

        private int parseValue(char[] data, int start, String key) throws IOException {
            int i = start;
            char c = data[i];
            if (c == '\"' || c == '\'') {
                return this.parseString(data, i, key);
            }
            if (c == '[') {
                return this.parseArray(data, i, key);
            }
            if (c == '{') {
                return this.parseInlineTable(data, i, key);
            }
            return this.parseLiteral(data, i, key);
        }

        private int parseString(char[] data, int start, String key) throws IOException {
            int i = start;
            int len = data.length;
            char quote = data[i];
            if (++i + 1 < len && data[i] == quote && data[i + 1] == quote) {
                return this.parseMultilineString(data, i += 2, key, quote);
            }
            StringBuilder value = new StringBuilder();
            while (i < len && data[i] != quote) {
                if (data[i] == '\\' && i + 1 < len) {
                    value.append(this.unescapeChar(data[++i]));
                } else {
                    if (data[i] == '\n') {
                        throw new IOException("Newline not allowed in single-line string");
                    }
                    value.append(data[i]);
                }
                ++i;
            }
            if (i >= len) {
                throw new IOException("Unclosed string");
            }
            this.values.put(key, value.toString());
            return this.skipToEndOfLine(data, ++i);
        }

        private int parseMultilineString(char[] data, int start, String key, char quote) throws IOException {
            int i = start;
            int len = data.length;
            StringBuilder value = new StringBuilder();
            if (i < len && data[i] == '\n') {
                ++i;
            }
            while (i < len) {
                if (i + 2 < len && data[i] == quote && data[i + 1] == quote && data[i + 2] == quote) {
                    this.values.put(key, value.toString());
                    return this.skipToEndOfLine(data, i += 3);
                }
                if (quote == '\"' && data[i] == '\\' && i + 1 < len) {
                    if (data[++i] == '\n' || data[i] == '\r' && i + 1 < len && data[i + 1] == '\n') {
                        while (i < len && Character.isWhitespace(data[i])) {
                            ++i;
                        }
                        continue;
                    }
                    value.append(this.unescapeChar(data[i]));
                } else {
                    value.append(data[i]);
                }
                ++i;
            }
            throw new IOException("Unclosed multi-line string");
        }

        private int parseArray(char[] data, int start, String key) throws IOException {
            int i = start + 1;
            int len = data.length;
            ArrayList<String> array = new ArrayList<String>();
            while (i < len) {
                while (i < len && (Character.isWhitespace(data[i]) || data[i] == '\n')) {
                    ++i;
                }
                if (i >= len) {
                    throw new IOException("Unclosed array");
                }
                if (data[i] == ']') {
                    this.values.put(key, array.toArray(new String[0]));
                    return this.skipToEndOfLine(data, ++i);
                }
                if (data[i] == '#') {
                    i = this.skipToEndOfLine(data, i);
                    continue;
                }
                StringBuilder element = new StringBuilder();
                array.add(element.toString());
                for (i = this.parseArrayElement(data, i, element); i < len && (Character.isWhitespace(data[i]) || data[i] == '\n'); ++i) {
                }
                if (i >= len || data[i] != ',') continue;
                ++i;
            }
            throw new IOException("Unclosed array");
        }

        private int parseArrayElement(char[] data, int start, StringBuilder element) throws IOException {
            int i;
            int len = data.length;
            char c = data[i];
            if (c == '\"' || c == '\'') {
                ++i;
                while (i < len && data[i] != c) {
                    if (data[i] == '\\' && i + 1 < len) {
                        element.append(this.unescapeChar(data[++i]));
                    } else {
                        element.append(data[i]);
                    }
                    ++i;
                }
                if (i >= len) {
                    throw new IOException("Unclosed string in array");
                }
                return ++i;
            }
            for (i = start; i < len && data[i] != ',' && data[i] != ']' && data[i] != '\n' && data[i] != '#'; ++i) {
                element.append(data[i]);
            }
            while (!element.isEmpty() && Character.isWhitespace(element.charAt(element.length() - 1))) {
                element.setLength(element.length() - 1);
            }
            return i;
        }

        private int parseInlineTable(char[] data, int start, String key) throws IOException {
            int i = start + 1;
            int len = data.length;
            while (i < len) {
                while (i < len && Character.isWhitespace(data[i])) {
                    ++i;
                }
                if (i >= len) {
                    throw new IOException("Unclosed inline table");
                }
                if (data[i] == '}') {
                    return this.skipToEndOfLine(data, ++i);
                }
                StringBuilder subKey = new StringBuilder();
                for (i = this.parseKey(data, i, subKey); i < len && Character.isWhitespace(data[i]); ++i) {
                }
                if (i >= len || data[i] != '=') {
                    throw new IOException("Expected '=' in inline table");
                }
                while (++i < len && Character.isWhitespace(data[i])) {
                }
                String fullKey = key + "." + subKey;
                for (i = this.parseValue(data, i, fullKey); i < len && Character.isWhitespace(data[i]); ++i) {
                }
                if (i >= len || data[i] != ',') continue;
                ++i;
            }
            throw new IOException("Unclosed inline table");
        }

        private int parseLiteral(char[] data, int start, String key) {
            int i;
            int len = data.length;
            StringBuilder value = new StringBuilder();
            for (i = start; i < len && !Character.isWhitespace(data[i]) && data[i] != '#' && data[i] != ',' && data[i] != ']' && data[i] != '}'; ++i) {
                value.append(data[i]);
            }
            String literal = value.toString();
            this.values.put(key, literal);
            return this.skipToEndOfLine(data, i);
        }

        private int skipToEndOfLine(char[] data, int start) {
            int i;
            int len = data.length;
            for (i = start; i < len && data[i] != '\n'; ++i) {
                if (data[i] == '#') {
                    while (i < len && data[i] != '\n') {
                        ++i;
                    }
                    break;
                }
                if (!Character.isWhitespace(data[i])) break;
            }
            if (i < len && data[i] == '\n') {
                ++i;
            }
            return i;
        }

        private boolean isKeyStart(char c) {
            return Character.isLetterOrDigit(c) || c == '_' || c == '\"' || c == '\'';
        }

        private char unescapeChar(char c) {
            return switch (c) {
                case 'n' -> '\n';
                case 'r' -> '\r';
                case 't' -> '\t';
                case 'b' -> '\b';
                case 'f' -> '\f';
                case '\\' -> '\\';
                case '\"' -> '\"';
                case '\'' -> '\'';
                default -> c;
            };
        }

        private String buildFullKey(String key) {
            if (this.currentTable.isEmpty()) {
                return key;
            }
            return this.currentTable + "." + key;
        }

        @Override
        public String read(String fieldName) {
            String key = Tools.concat("", (!this.group.isEmpty() ? "." : "") + fieldName, '.', this.group);
            Object value = this.values.get(key);
            if (value instanceof String) {
                String s = (String)value;
                return s;
            }
            return null;
        }

        @Override
        public String[] readArray(String fieldName) {
            String key = Tools.concat("", (!this.group.isEmpty() ? "." : "") + fieldName, '.', this.group);
            Object value = this.values.get(key);
            if (value instanceof String[]) {
                String[] s = (String[])value;
                return s;
            }
            return null;
        }

        @Override
        public void push(String group) {
            this.group.push(group);
        }

        @Override
        public void pop() {
            if (!this.group.isEmpty()) {
                this.group.pop();
            }
        }

        @Override
        public void close() {
            this.values.clear();
            this.group.clear();
        }
    }

    public static class FormatWriter
    implements IFormatWriter {
        private final Stack<String> group = new Stack();
        private final BufferedWriter writer;
        private final StringBuilder buffer = new StringBuilder();
        private final List<String> comments = new ArrayList<String>();
        private String currentTable = "";
        private boolean tableHeaderWritten = false;

        public FormatWriter(Path path) throws IOException {
            if (!path.toFile().getParentFile().exists() && !path.toFile().getParentFile().mkdirs()) {
                throw new IOException("Failed to create parent directories for " + path);
            }
            this.writer = new BufferedWriter(new FileWriter(path.toFile(), StandardCharsets.UTF_8));
        }

        @Override
        public void write(String comment) {
            this.comments.add(comment);
        }

        @Override
        public void write(String fieldName, String value, Class<?> type, Class<?> subType) {
            this.ensureTableHeader();
            for (String comment : this.comments) {
                this.buffer.append("# ").append(comment).append("\n");
            }
            this.comments.clear();
            this.buffer.append(this.escapeKey(fieldName)).append(" = ");
            this.buffer.append(this.formatValue(value, type));
            this.buffer.append("\n");
        }

        @Override
        public void write(String fieldName, String[] values, Class<?> type, Class<?> subType) {
            this.ensureTableHeader();
            for (String comment : this.comments) {
                this.buffer.append("# ").append(comment).append("\n");
            }
            this.comments.clear();
            this.buffer.append(this.escapeKey(fieldName)).append(" = [");
            if (values.length > 0) {
                this.buffer.append("\n");
                for (int i = 0; i < values.length; ++i) {
                    this.buffer.append("  ").append(this.formatValue(values[i], subType));
                    if (i < values.length - 1) {
                        this.buffer.append(",");
                    }
                    this.buffer.append("\n");
                }
            }
            this.buffer.append("]\n");
        }

        @Override
        public void push(String groupName) {
            this.group.push(groupName);
            this.tableHeaderWritten = false;
        }

        @Override
        public void pop() {
            if (!this.group.isEmpty()) {
                this.group.pop();
                this.tableHeaderWritten = false;
            }
        }

        @Override
        public void close() throws IOException {
            this.writer.write(this.buffer.toString());
            this.writer.flush();
            this.writer.close();
        }

        private void ensureTableHeader() {
            String tableName = this.buildTableName();
            if (!tableName.equals(this.currentTable) || !this.tableHeaderWritten) {
                if (!this.buffer.isEmpty()) {
                    this.buffer.append("\n");
                }
                if (!tableName.isEmpty()) {
                    this.buffer.append("[").append(tableName).append("]\n");
                }
                this.currentTable = tableName;
                this.tableHeaderWritten = true;
            }
        }

        private String buildTableName() {
            if (this.group.isEmpty()) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            Iterator it = this.group.iterator();
            while (it.hasNext()) {
                sb.append(this.escapeKey((String)it.next()));
                if (!it.hasNext()) continue;
                sb.append(".");
            }
            return sb.toString();
        }

        private String escapeKey(String key) {
            if (key.matches("[A-Za-z0-9_-]+")) {
                return key;
            }
            return "\"" + key.replace("\\", "\\\\").replace("\"", "\\\"") + "\"";
        }

        private String formatValue(String value, Class<?> type) {
            if (type == null) {
                return "\"" + this.escapeString(value) + "\"";
            }
            if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) {
                return value.toLowerCase();
            }
            if (Number.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type)) {
                return value;
            }
            return "\"" + this.escapeString(value) + "\"";
        }

        private String escapeString(String str) {
            return str.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t").replace("\b", "\\b").replace("\f", "\\f");
        }
    }
}

