/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.decode;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ServiceLoader;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.watermedia.WaterMedia;
import org.watermedia.api.WaterMediaAPI;
import org.watermedia.api.decode.Decoder;
import org.watermedia.api.decode.Image;

public class DecoderAPI
extends WaterMediaAPI {
    private static final Marker IT = MarkerManager.getMarker((String)DecoderAPI.class.getSimpleName());
    private static ServiceLoader<Decoder> SERVICE;

    public static Image decodeImage(byte[] data) {
        return DecoderAPI.decodeImage(ByteBuffer.wrap(data));
    }

    public static Image decodeImage(ByteBuffer buffer) {
        for (Decoder decoder : SERVICE) {
            if (!decoder.supported(buffer)) continue;
            try {
                return decoder.decode(buffer);
            }
            catch (IOException e) {
                WaterMedia.LOGGER.error(IT, "Decoding failed: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        WaterMedia.LOGGER.warn(IT, "No decoder founded");
        return null;
    }

    @Override
    public boolean start(WaterMedia instance) throws Exception {
        WaterMedia.LOGGER.info(IT, "Loading image decoders");
        SERVICE = ServiceLoader.load(Decoder.class);
        for (Decoder decoder : SERVICE) {
            WaterMedia.LOGGER.info(IT, "Testing {}", (Object)decoder.getClass().getSimpleName());
            if (decoder.test()) continue;
            WaterMedia.LOGGER.debug(IT, "Decoder {} fail test", (Object)decoder.getClass().getSimpleName());
        }
        WaterMedia.LOGGER.info(IT, "All decoders loaded");
        return true;
    }

    @Override
    public boolean onlyClient() {
        WaterMedia.LOGGER.warn(IT, "DecoderAPI is not client-side only, but is recommended to be used only in client-side");
        return false;
    }

    @Override
    public void test() {
    }

    @Override
    public WaterMediaAPI.Priority priority() {
        return WaterMediaAPI.Priority.NORMAL;
    }

    @Override
    public void release(WaterMedia instance) {
        SERVICE = null;
    }
}

