/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.decode;

import java.nio.ByteBuffer;
import org.watermedia.tools.DataTool;

public record Image(ByteBuffer[] frames, int width, int height, long[] delay, long duration, int repeat) {
    private final long duration;
    public static final int REPEAT_FOREVER = 0;
    public static final int NO_REPEAT = -1;

    public Image {
        if (frames == null || frames.length == 0) {
            throw new IllegalArgumentException("At least one image is required");
        }
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Width and height must be positive");
        }
        if (delay == null || delay.length != frames.length) {
            throw new IllegalArgumentException("Delay array must match the number of frames");
        }
        if (duration <= 0L) {
            throw new IllegalArgumentException("Total duration must be positive");
        }
        if (repeat < -1) {
            throw new IllegalArgumentException("Repeat must be NO_REPEAT (-1) or REPEAT_FOREVER (0) or a positive integer");
        }
    }

    public Image(ByteBuffer[] images, int width, int height, long[] delay, int repeat) {
        this(images, width, height, delay, DataTool.sumArray(delay), repeat);
    }

    public long duration() {
        if (this.repeat() > 0) {
            return this.duration * (long)this.repeat();
        }
        return this.duration;
    }
}

