/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.decode.formats.gif;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.watermedia.WaterMedia;
import org.watermedia.api.decode.Decoder;
import org.watermedia.api.decode.Image;
import org.watermedia.api.decode.formats.gif.packets.ColorTable;
import org.watermedia.api.decode.formats.gif.packets.GraphicExtension;
import org.watermedia.api.decode.formats.gif.packets.ImageDescriptor;
import org.watermedia.api.decode.formats.gif.packets.ScreenDescriptor;
import org.watermedia.tools.DataTool;

public class GIF
extends Decoder {
    private static final Marker IT = MarkerManager.getMarker((String)"GIFDecoder");
    private static final long GIF87A = 78380036274017L;
    private static final long GIF89A = 78380036274529L;
    private static final ByteOrder DEFAULT_BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private static final int IMAGE_SEPARATOR = 44;
    private static final int EXTENSION_INTRODUCER = 33;
    private static final int TRAILER = 59;
    private static final int APPLICATION_EXTENSION_LABEL = 255;
    private static final int COMMENT_EXTENSION_LABEL = 254;
    private static final int MIN_LZW_CODE_SIZE = 2;
    private static final int MAX_LZW_CODE_SIZE = 8;
    private static final int MAX_STACK_SIZE = 4096;
    private static final int STACK_BUFFER_SIZE = 4097;
    private static final int[] PASS_STARTS = new int[]{0, 4, 2, 1};
    private static final int[] PASS_INCREMENTS = new int[]{8, 8, 4, 2};
    private static final long DEFAULT_FRAME_DELAY = 10L;
    private static final int DELAY_TIME_MULTIPLIER = 10;
    private static final int OPAQUE_BLACK = -16777216;
    private static final long NETSCAPE_EXT_ID = 5640006824938786885L;
    private static final int NETSCAPE_AUTH_CODE = 540159536;
    private static final int NETSCAPE_BLOCK_SIZE = 11;
    private static final int NETSCAPE_SUB_BLOCK_SIZE = 3;
    private static final int NETSCAPE_SUB_BLOCK_ID = 1;

    @Override
    public boolean supported(ByteBuffer buffer) {
        if (buffer.remaining() < 6) {
            return false;
        }
        ByteOrder ogOrder = buffer.order();
        buffer.order(DEFAULT_BYTE_ORDER);
        long signature = DataTool.readBytesAsLong(buffer, 6, ByteOrder.BIG_ENDIAN);
        if (signature != 78380036274017L && signature != 78380036274529L) {
            buffer.rewind();
            buffer.order(ogOrder);
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Image decode(ByteBuffer buffer) throws IOException {
        buffer.order(DEFAULT_BYTE_ORDER);
        ScreenDescriptor lsd = ScreenDescriptor.read(buffer);
        ColorTable globalColorTable = null;
        if (lsd.globalColorTableFlag()) {
            globalColorTable = ColorTable.read(1 << lsd.globalColorTableSize() + 1, buffer);
        }
        ArrayList<ByteBuffer> frames = new ArrayList<ByteBuffer>();
        ArrayList<Long> delays = new ArrayList<Long>();
        int repeatCount = -1;
        GraphicExtension currentGce = null;
        int[] previousFrame = null;
        int backgroundColor = -16777216;
        if (globalColorTable != null && lsd.backgroundColorIndex() < globalColorTable.colors().length) {
            backgroundColor = globalColorTable.colors()[lsd.backgroundColorIndex()];
        }
        block9: while (buffer.hasRemaining()) {
            int introducer = Byte.toUnsignedInt(buffer.get());
            switch (introducer) {
                case 44: {
                    ImageDescriptor id = ImageDescriptor.read(buffer);
                    ColorTable activeColorTable = globalColorTable;
                    if (id.localColorTableFlag()) {
                        activeColorTable = ColorTable.read(id.getLocalColorTableSize(), buffer);
                        WaterMedia.LOGGER.debug(IT, "Local Color Table Size: {}", (Object)activeColorTable.size());
                    }
                    if (activeColorTable == null) {
                        throw new IOException("No color table available for image frame.");
                    }
                    int[] decompressedIndices = this.decompress(id, buffer);
                    int[] currentFramePixels = frames.isEmpty() ? this.createNewCanvas(lsd.width(), lsd.height(), backgroundColor) : this.disposal(previousFrame, currentGce, lsd, backgroundColor, id);
                    this.renderImage(decompressedIndices, currentFramePixels, id, lsd, activeColorTable, currentGce);
                    ByteBuffer frameBuffer = ByteBuffer.allocateDirect(lsd.width() * lsd.height() * 4);
                    frameBuffer.order(DEFAULT_BYTE_ORDER);
                    frameBuffer.asIntBuffer().put(currentFramePixels);
                    frameBuffer.flip();
                    frames.add(frameBuffer);
                    previousFrame = (int[])currentFramePixels.clone();
                    long delay = currentGce != null && currentGce.delayTime() > 0 ? (long)currentGce.delayTime() * 10L : 10L;
                    delays.add(delay);
                    currentGce = null;
                    break;
                }
                case 33: {
                    int label = Byte.toUnsignedInt(buffer.get());
                    switch (label) {
                        case 249: {
                            currentGce = GraphicExtension.read(buffer);
                            break;
                        }
                        case 255: {
                            int loopCount = this.readAppExtension(buffer);
                            if (loopCount < 0) break;
                            repeatCount = loopCount;
                            break;
                        }
                        default: {
                            this.skipSubBlocks(buffer);
                            break;
                        }
                    }
                    break;
                }
                case 59: {
                    break block9;
                }
            }
        }
        if (frames.isEmpty()) {
            throw new IOException("GIF stream contains no image data.");
        }
        long[] delayArray = delays.stream().mapToLong(Long::longValue).toArray();
        return new Image((ByteBuffer[])frames.toArray(ByteBuffer[]::new), lsd.width(), lsd.height(), delayArray, repeatCount);
    }

    @Override
    public boolean test() {
        return false;
    }

    private void renderImage(int[] indexes, int[] canvas, ImageDescriptor id, ScreenDescriptor lsd, ColorTable colorTable, GraphicExtension gce) {
        int transparentIndex = gce != null && gce.transparentColorFlag() ? gce.transparentColorIndex() : -1;
        int srcIdx = 0;
        if (id.interlacedFlag()) {
            for (int pass = 0; pass < PASS_STARTS.length; ++pass) {
                for (int y = PASS_STARTS[pass]; y < id.height(); y += PASS_INCREMENTS[pass]) {
                    for (int x = 0; x < id.width(); ++x) {
                        int colorIndex;
                        if (srcIdx >= indexes.length) {
                            return;
                        }
                        if ((colorIndex = indexes[srcIdx++]) == transparentIndex) continue;
                        int destX = id.left() + x;
                        int destY = id.top() + y;
                        if (destX < 0 || destX >= lsd.width() || destY < 0 || destY >= lsd.height() || colorIndex >= colorTable.colors().length) continue;
                        canvas[destY * lsd.width() + destX] = colorTable.colors()[colorIndex];
                    }
                }
            }
        } else {
            for (int y = 0; y < id.height(); ++y) {
                for (int x = 0; x < id.width(); ++x) {
                    int colorIndex;
                    if (srcIdx >= indexes.length) {
                        return;
                    }
                    if ((colorIndex = indexes[srcIdx++]) == transparentIndex) continue;
                    int destX = id.left() + x;
                    int destY = id.top() + y;
                    if (destX < 0 || destX >= lsd.width() || destY < 0 || destY >= lsd.height() || colorIndex >= colorTable.colors().length) continue;
                    canvas[destY * lsd.width() + destX] = colorTable.colors()[colorIndex];
                }
            }
        }
    }

    private int[] createNewCanvas(int width, int height, int backgroundColor) {
        int[] canvas = new int[width * height];
        Arrays.fill(canvas, backgroundColor);
        return canvas;
    }

    private int[] decompress(ImageDescriptor id, ByteBuffer buffer) throws IOException {
        int lzwMinCodeSize = Byte.toUnsignedInt(buffer.get());
        if (lzwMinCodeSize < 2 || lzwMinCodeSize > 8) {
            throw new IOException("Invalid LZW minimum code size: " + lzwMinCodeSize);
        }
        int clearCode = 1 << lzwMinCodeSize;
        int endOfInfoCode = clearCode + 1;
        ByteBuffer data = this.readSubBlocks(buffer);
        int expectedSize = id.width() * id.height();
        int[] output = new int[expectedSize];
        short[] prefix = new short[4096];
        byte[] suffix = new byte[4096];
        byte[] pixelStack = new byte[4097];
        for (int i = 0; i < clearCode; ++i) {
            prefix[i] = 0;
            suffix[i] = (byte)i;
        }
        int codeSize = lzwMinCodeSize + 1;
        int codeMask = (1 << codeSize) - 1;
        int available = clearCode + 2;
        int datum = 0;
        int bits = 0;
        int oldCode = -1;
        int first = 0;
        int top = 0;
        int pi = 0;
        int i = 0;
        while (i < expectedSize) {
            if (top == 0) {
                if (bits < codeSize) {
                    if (!data.hasRemaining()) break;
                    datum += (data.get() & 0xFF) << bits;
                    bits += 8;
                    continue;
                }
                int code = datum & codeMask;
                datum >>= codeSize;
                bits -= codeSize;
                if (code > available || code == endOfInfoCode) break;
                if (code == clearCode) {
                    codeSize = lzwMinCodeSize + 1;
                    codeMask = (1 << codeSize) - 1;
                    available = clearCode + 2;
                    oldCode = -1;
                    continue;
                }
                if (oldCode == -1) {
                    pixelStack[top++] = suffix[code];
                    oldCode = code;
                    first = code;
                    continue;
                }
                int inCode = code;
                if (code == available) {
                    pixelStack[top++] = (byte)first;
                    code = oldCode;
                }
                while (code > clearCode) {
                    if (top >= 4096) {
                        throw new IOException("LZW stack overflow");
                    }
                    pixelStack[top++] = suffix[code];
                    code = prefix[code];
                }
                first = suffix[code] & 0xFF;
                if (available >= 4096) {
                    pixelStack[top++] = (byte)first;
                } else {
                    pixelStack[top++] = (byte)first;
                    prefix[available] = (short)oldCode;
                    suffix[available] = (byte)first;
                    if ((++available & codeMask) == 0 && available < 4096) {
                        ++codeSize;
                        codeMask += available;
                    }
                }
                oldCode = inCode;
            }
            output[pi++] = pixelStack[--top] & 0xFF;
            ++i;
        }
        return output;
    }

    private int[] disposal(int[] prevFrame, GraphicExtension gce, ScreenDescriptor lsd, int background, ImageDescriptor id) {
        if (prevFrame == null) {
            return this.createNewCanvas(lsd.width(), lsd.height(), background);
        }
        int disposal = gce != null ? gce.disposalMethod() : 0;
        return switch (disposal) {
            case 2 -> {
                int[] frame = (int[])prevFrame.clone();
                for (int y = 0; y < id.height(); ++y) {
                    for (int x = 0; x < id.width(); ++x) {
                        int canvasX = id.left() + x;
                        int canvasY = id.top() + y;
                        if (canvasX < 0 || canvasX >= lsd.width() || canvasY < 0 || canvasY >= lsd.height()) continue;
                        frame[canvasY * lsd.width() + canvasX] = background;
                    }
                }
                yield frame;
            }
            default -> (int[])prevFrame.clone();
        };
    }

    private int readAppExtension(ByteBuffer buffer) {
        byte blockSize = buffer.get();
        if (blockSize != 11) {
            buffer.position(buffer.position() + blockSize);
            this.skipSubBlocks(buffer);
            return -1;
        }
        long id = DataTool.readBytesAsLong(buffer, 8, DEFAULT_BYTE_ORDER);
        int auth = DataTool.readBytesAsInt(buffer, 3, DEFAULT_BYTE_ORDER);
        if (id == 5640006824938786885L && auth == 540159536) {
            if (3 == buffer.get() && 1 == buffer.get()) {
                int loopCount = Short.toUnsignedInt(buffer.getShort());
                if (loopCount == 0) {
                    loopCount = 0;
                }
                this.skipSubBlocks(buffer);
                WaterMedia.LOGGER.debug(IT, "Found NETSCAPE 2.0 extension with loop count: {}", (Object)loopCount);
                return loopCount;
            }
        } else {
            WaterMedia.LOGGER.debug(IT, "Unknown application extension: ID={} AUTH={}", (Object)Long.toHexString(id), (Object)Integer.toHexString(auth));
        }
        this.skipSubBlocks(buffer);
        return -1;
    }

    private void skipSubBlocks(ByteBuffer buffer) {
        int blockSize;
        while ((blockSize = Byte.toUnsignedInt(buffer.get())) > 0) {
            buffer.position(buffer.position() + blockSize);
        }
        WaterMedia.LOGGER.trace(IT, "Skipped sub-blocks");
    }

    private ByteBuffer readSubBlocks(ByteBuffer buffer) {
        int blockSize;
        ArrayList<byte[]> blocks = new ArrayList<byte[]>(255);
        int totalSize = 0;
        while ((blockSize = Byte.toUnsignedInt(buffer.get())) > 0) {
            byte[] block = new byte[blockSize];
            buffer.get(block);
            blocks.add(block);
            totalSize += blockSize;
        }
        ByteBuffer result = ByteBuffer.allocate(totalSize);
        result.order(DEFAULT_BYTE_ORDER);
        blocks.forEach(result::put);
        result.flip();
        return result;
    }
}

