/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.decode.formats.gif.packets;

import java.nio.ByteBuffer;

public record ImageDescriptor(int left, int top, int width, int height, boolean localColorTableFlag, boolean interlacedFlag, boolean sortFlag, int localColorTableSize) {
    public static final int LOCAL_COLOR_TABLE_SIZE = 8;

    public ImageDescriptor {
        if (left < 0 || top < 0 || width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Invalid dimensions for ImageDescriptor");
        }
        if (localColorTableSize < 0 || localColorTableSize > 8) {
            throw new IllegalArgumentException("Local color table size must be between 0 and 8");
        }
    }

    public int getLocalColorTableSize() {
        return 1 << this.localColorTableSize + 1;
    }

    public static ImageDescriptor read(ByteBuffer buffer) {
        if (buffer.remaining() < 10) {
            throw new IllegalArgumentException("Buffer does not contain enough data for Image Descriptor");
        }
        int left = Short.toUnsignedInt(buffer.getShort());
        int top = Short.toUnsignedInt(buffer.getShort());
        int width = Short.toUnsignedInt(buffer.getShort());
        int height = Short.toUnsignedInt(buffer.getShort());
        int packedFields = Byte.toUnsignedInt(buffer.get());
        boolean localColorTableFlag = (packedFields & 0x80) != 0;
        boolean interlacedFlag = (packedFields & 0x40) != 0;
        boolean sortFlag = (packedFields & 0x20) != 0;
        int localColorTableSize = packedFields & 7;
        return new ImageDescriptor(left, top, width, height, localColorTableFlag, interlacedFlag, sortFlag, localColorTableSize);
    }
}

