/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.decode.formats.png.chunks;

import java.nio.ByteBuffer;

public record CHUNK(int length, int type, byte[] data, int crc) {
    private static final int[] CRC_TABLE = new int[256];

    public static CHUNK read(ByteBuffer buffer) {
        int length = buffer.getInt();
        int type = buffer.getInt();
        byte[] data = new byte[length];
        buffer.get(data, 0, length);
        int crc = buffer.getInt();
        return new CHUNK(length, type, data, crc);
    }

    public boolean corrupted() {
        int crcCalc = -1;
        for (int i = 0; i < 4; ++i) {
            int b = this.type >> 24 - i * 8 & 0xFF;
            crcCalc = CRC_TABLE[(crcCalc ^ b) & 0xFF] ^ crcCalc >>> 8;
        }
        for (byte b : this.data) {
            crcCalc = CRC_TABLE[(crcCalc ^ b) & 0xFF] ^ crcCalc >>> 8;
        }
        return (crcCalc ^= 0xFFFFFFFF) != this.crc;
    }

    static {
        for (int n = 0; n < 256; ++n) {
            int c = n;
            for (int k = 0; k < 8; ++k) {
                if ((c & 1) != 0) {
                    c = 0xEDB88320 ^ c >>> 1;
                    continue;
                }
                c >>>= 1;
            }
            CHUNK.CRC_TABLE[n] = c;
        }
    }
}

